<?php
require 'db.php';
require 'auth.php';

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = $_POST['password'] ?? '';
  
  $stmt = $db->prepare('SELECT * FROM users WHERE username = ?');
  $stmt->execute([$username]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);
  
  if ($user && password_verify($password, $user['password_hash'])) {
    $_SESSION['user'] = [
      'id' => $user['id'],
      'username' => $user['username'],
      'nama_lengkap' => $user['nama_lengkap'],
      'role' => $user['role']
    ];
    header('Location: index.php');
    exit;
  } else {
    $error = 'Username atau password salah';
  }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login - Sistem Peminjaman Berkas</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
.login-container {
  background: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('gambar/gedung-pn-wtp.png');
  background-size: 120%;
  background-position: center top;
  background-repeat: no-repeat;
  background-attachment: fixed;
  background-color: #2c3e50;
  min-height: 100vh;
}

.login-card {
  background: rgba(255,255,255,0.95);
  backdrop-filter: blur(10px);
  border: none;
  border-radius: 20px;
  box-shadow: 0 20px 40px rgba(0,0,0,0.3);
}

.logo-container {
  background: white;
  border-radius: 50%;
  width: 120px;
  height: 120px;
  display: flex;
  align-items: center;
  justify-content: center;
  margin: -60px auto 25px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.logo-container img {
  width: 110px;
  height: 110px;
  object-fit: contain;
}

.form-control {
  border-radius: 15px;
  border: 2px solid #e0e0e0;
  padding: 12px 15px;
  transition: all 0.3s ease;
}

.form-control:focus {
  border-color: #0d6efd;
  box-shadow: 0 0 0 0.2rem rgba(13,110,253,.25);
  transform: translateY(-2px);
}

.btn-login {
  border-radius: 15px;
  padding: 12px;
  font-weight: 600;
  background: linear-gradient(45deg, #0d6efd, #0056b3);
  border: none;
  transition: all 0.3s ease;
}

.btn-login:hover {
  transform: translateY(-2px);
  box-shadow: 0 8px 25px rgba(13,110,253,0.4);
}

.title-text {
  color: #2c3e50;
  font-weight: 700;
  text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
}

.subtitle-text {
  color: #7f8c8d;
  font-weight: 500;
}

.input-group-text {
  border-radius: 15px 0 0 15px;
  border: 2px solid #e0e0e0;
  border-right: none;
  background: #f8f9fa;
}

.form-control:focus + .input-group-text,
.input-group-text:focus-within {
  border-color: #0d6efd;
}
</style>
</head>
<body class="login-container d-flex align-items-center">

<div class="container">
  <div class="row justify-content-center">
    <div class="col-lg-4 col-md-5 col-sm-7">
      <div class="card login-card">
        <div class="card-body p-4">
          <!-- Logo -->
          <div class="logo-container">
            <img src="gambar/Logo_pnwtp.png" alt="Logo PN Watampone">
          </div>
          
          <!-- Title -->
          <div class="text-center mb-3">
            <h4 class="title-text mb-1">Selamat Datang</h4>
            <p class="subtitle-text mb-0 small">Sistem Peminjaman Berkas</p>
            <p class="subtitle-text small"><strong>Pengadilan Negeri Watampone</strong></p>
          </div>
          
          <?php if($error): ?>
            <div class="alert alert-danger rounded-3">
              <i class="fa fa-exclamation-triangle"></i> <?= htmlspecialchars($error) ?>
            </div>
          <?php endif; ?>
          
          <form method="post">
            <div class="mb-3">
              <label class="form-label fw-semibold small">Username</label>
              <div class="input-group">
                <span class="input-group-text"><i class="fa fa-user text-primary"></i></span>
                <input name="username" class="form-control" placeholder="Masukkan username" required autocomplete="username">
              </div>
            </div>
            
            <div class="mb-3">
              <label class="form-label fw-semibold small">Password</label>
              <div class="input-group">
                <span class="input-group-text"><i class="fa fa-lock text-primary"></i></span>
                <input type="password" name="password" class="form-control" placeholder="Masukkan password" required autocomplete="current-password">
              </div>
            </div>
            
            <button type="submit" class="btn btn-primary btn-login w-100 mb-3">
              <i class="fa fa-sign-in-alt me-2"></i> Masuk ke Sistem
            </button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

</body>
</html>
