<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Set timezone untuk WITA (Waktu Indonesia Tengah) - UTC+8
// Sesuai untuk Watampone, Sulawesi Selatan
date_default_timezone_set('Asia/Makassar');

$rootDir = __DIR__;
$dataDir = $rootDir . DIRECTORY_SEPARATOR . 'data';
$dbFile  = $dataDir . DIRECTORY_SEPARATOR . 'data.sqlite';

if (!is_dir($dataDir)) { @mkdir($dataDir, 0777, true); }
if (!file_exists($dbFile)) { @file_put_contents($dbFile, ''); @chmod($dbFile, 0666); }

try {
  $db = new PDO('sqlite:' . $dbFile);
  $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) { die('DB error: ' . $e->getMessage()); }

// Tables
$db->exec("CREATE TABLE IF NOT EXISTS peminjaman (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  nama TEXT NOT NULL,
  jabatan TEXT NOT NULL,
  tujuan TEXT NOT NULL,
  nomor_perkara TEXT NOT NULL,
  nama_pihak TEXT NOT NULL,
  nama_pihak_lain TEXT,
  tanggal_ambil TEXT NOT NULL,
  tanggal_kembali TEXT NOT NULL,
  tanggal_kembali_real TEXT,
  status TEXT DEFAULT 'dipinjam',
  perpanjangan_count INTEGER DEFAULT 0,
  penandatangan TEXT DEFAULT 'ketua',
  bukti_dicetak INTEGER DEFAULT 0,
  bukti_dicetak_oleh TEXT,
  bukti_dicetak_waktu TEXT,
  waktu_kembali_real TEXT
);");

$db->exec("CREATE TABLE IF NOT EXISTS settings (
  key TEXT PRIMARY KEY,
  value TEXT
);");

$db->exec("CREATE TABLE IF NOT EXISTS users (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  username TEXT UNIQUE NOT NULL,
  nama_lengkap TEXT NOT NULL,
  password_hash TEXT NOT NULL,
  role TEXT NOT NULL DEFAULT 'petugas',
  created_at TEXT DEFAULT CURRENT_TIMESTAMP
);");

// Default admin if none
$hasUsers = $db->query('SELECT COUNT(*) FROM users')->fetchColumn();
if ((int)$hasUsers === 0) {
  $st = $db->prepare('INSERT INTO users(username,nama_lengkap,password_hash,role) VALUES(?,?,?,?)');
  $st->execute(['admin', 'Administrator', password_hash('admin123', PASSWORD_DEFAULT), 'admin']);
}

// Check if nama_lengkap column exists, if not add it
try {
  $db->query("SELECT nama_lengkap FROM users LIMIT 1");
} catch (PDOException $e) {
  $db->exec("ALTER TABLE users ADD COLUMN nama_lengkap TEXT");
  // Update existing users yang belum punya nama_lengkap
  $db->exec("UPDATE users SET nama_lengkap = username WHERE nama_lengkap IS NULL OR nama_lengkap = ''");
}

// Functions
function setting_get($key, $default='') {
  global $db;
  $st = $db->prepare('SELECT value FROM settings WHERE key=?');
  $st->execute([$key]);
  $r = $st->fetch(PDO::FETCH_ASSOC);
  return $r ? $r['value'] : $default;
}

function setting_set($key, $value) {
  global $db;
  $st = $db->prepare('INSERT OR REPLACE INTO settings(key, value) VALUES(?, ?)');
  $st->execute([$key, $value]);
}

// Set default settings if not exist
$defaults = [
  'ketua_nama' => 'H. Abdul Rahman, S.H., M.H.',
  'wakil_nama' => 'Drs. Muhammad Saleh, S.H.',
  'panitera_nama' => 'Hj. Siti Nurhaliza, S.H.',
  'panmud_nama' => 'Ahmad Fauzi, S.H.'
];

foreach($defaults as $key => $value) {
  if (!setting_get($key)) {
    setting_set($key, $value);
  }
}

// Check if waktu_kembali_real column exists, if not add it
try {
  $db->query("SELECT waktu_kembali_real FROM peminjaman LIMIT 1");
} catch (PDOException $e) {
  $db->exec("ALTER TABLE peminjaman ADD COLUMN waktu_kembali_real TEXT");
}

// Check if edit_count column exists, if not add it
try {
  $db->query("SELECT edit_count FROM peminjaman LIMIT 1");
} catch (PDOException $e) {
  $db->exec("ALTER TABLE peminjaman ADD COLUMN edit_count INTEGER DEFAULT 0");
}

// Seeding disabled - removed automatic test data generation
// Previously this would add 20 test records when table was empty
// Uncomment below if you need test data for development:

/*
// Seed some data for testing if table is empty
$hasData = $db->query('SELECT COUNT(*) FROM peminjaman')->fetchColumn();
if ((int)$hasData === 0) {
  for($i = 1; $i <= 20; $i++) {
    $ambil = date('Y-m-d', strtotime("-".(20-$i)." days"));
    $kembali = date('Y-m-d', strtotime($ambil . " +3 days"));
    $status = $i > 15 ? 'kembali' : 'dipinjam';
    $real_kembali = $status === 'kembali' ? $kembali : null;
    $real_waktu = $status === 'kembali' ? date('H:i:s', strtotime('14:' . str_pad($i, 2, '0', STR_PAD_LEFT) . ':00')) : null;
    
    $stmt = $db->prepare("INSERT INTO peminjaman (nama, jabatan, tujuan, nomor_perkara, nama_pihak, nama_pihak_lain, tanggal_ambil, tanggal_kembali, tanggal_kembali_real, waktu_kembali_real, status, perpanjangan_count, penandatangan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
      "Peminjam Test $i",
      "Jabatan $i",
      "Keperluan Test $i",
      sprintf("%03d/Pid.B/2025/PN.Wtp", $i),
      "Pihak A $i",
      "Pihak B $i",
      $ambil,
      $kembali,
      $real_kembali,
      $real_waktu,
      $status,
      rand(0, 2),
      $i % 2 === 0 ? 'wakil' : 'ketua'
    ]);
  }
}
*/
?>
