<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';

// Get current settings
$ketua_nama = setting_get('ketua_nama', 'H. Abdul Rahman, S.H., M.H.');
$wakil_nama = setting_get('wakil_nama', 'Drs. Muhammad Saleh, S.H.');
$panitera_nama = setting_get('panitera_nama', 'Hj. Siti Nurhaliza, S.H.');
$panmud_nama = setting_get('panmud_nama', 'Ahmad Fauzi, S.H.');
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Pengaturan Pejabat - Sistem Peminjaman Berkas</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
<style>
body { background: #f5f7fb; }
</style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <a class="navbar-brand d-flex align-items-center" href="index.php">
      <img src="gambar/Logo_pnwtp.png" alt="Logo PN Watampone" width="70" height="70" class="me-3">
      <span><i class="fa fa-book me-1"></i> Sistem Peminjaman Berkas<br><small>Pengadilan Negeri Watampone</small></span>
    </a>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-light btn-sm" href="index.php"><i class="fa fa-home"></i> Dashboard</a>
      <a class="btn btn-outline-light btn-sm" href="backup-restore.php"><i class="fa fa-database"></i> Backup</a>
      <a class="btn btn-outline-light btn-sm" href="change-password.php"><i class="fa fa-key"></i> Password</a>
      <a class="btn btn-outline-light btn-sm" href="admin/users.php"><i class="fa fa-users"></i> Akun</a>
      <span class="navbar-text text-light">Hi, <?=htmlspecialchars(current_user()['nama_lengkap'] ?? current_user()['username'])?></span>
      <a class="btn btn-outline-light btn-sm" href="logout.php"><i class="fa fa-sign-out-alt"></i> Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-md-8">
      <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
          <h4 class="mb-0"><i class="fa fa-cog"></i> Pengaturan Pejabat</h4>
          <small>Kelola nama-nama pejabat untuk penandatanganan surat</small>
        </div>
        <div class="card-body">
          
          <?php if($success): ?>
            <div class="alert alert-success alert-dismissible fade show">
              <i class="fa fa-check-circle"></i> Pengaturan berhasil disimpan!
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>
          
          <?php if($error): ?>
            <div class="alert alert-danger alert-dismissible fade show">
              <i class="fa fa-exclamation-triangle"></i> <?= htmlspecialchars($error) ?>
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>
          
          <form method="post" action="settings_save.php">
            <div class="row g-3">
              
              <div class="col-md-6">
                <label class="form-label">
                  <i class="fa fa-user-tie"></i> Ketua Pengadilan Negeri *
                </label>
                <input type="text" name="ketua_nama" class="form-control" 
                       value="<?= htmlspecialchars($ketua_nama) ?>" required>
                <small class="form-text text-muted">
                  Akan muncul di surat dengan penandatangan "Ketua Pengadilan"
                </small>
              </div>
              
              <div class="col-md-6">
                <label class="form-label">
                  <i class="fa fa-user-tie"></i> Wakil Ketua Pengadilan Negeri *
                </label>
                <input type="text" name="wakil_nama" class="form-control" 
                       value="<?= htmlspecialchars($wakil_nama) ?>" required>
                <small class="form-text text-muted">
                  Akan muncul di surat dengan penandatangan "Wakil Ketua Pengadilan"
                </small>
              </div>
              
              <div class="col-md-6">
                <label class="form-label">
                  <i class="fa fa-user"></i> Panitera *
                </label>
                <input type="text" name="panitera_nama" class="form-control" 
                       value="<?= htmlspecialchars($panitera_nama) ?>" required>
                <small class="form-text text-muted">
                  Untuk persetujuan di bukti pengembalian
                </small>
              </div>
              
              <div class="col-md-6">
                <label class="form-label">
                  <i class="fa fa-user"></i> Panmud Hukum *
                </label>
                <input type="text" name="panmud_nama" class="form-control" 
                       value="<?= htmlspecialchars($panmud_nama) ?>" required>
                <small class="form-text text-muted">
                  Untuk pemeriksaan di bukti pengembalian
                </small>
              </div>
              
            </div>
            
            <hr>
            
            <div class="d-flex justify-content-between">
              <a href="index.php" class="btn btn-secondary">
                <i class="fa fa-arrow-left"></i> Kembali
              </a>
              <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Simpan Pengaturan
              </button>
            </div>
          </form>
          
        </div>
      </div>
      
      <!-- Preview Tanda Tangan -->
      <div class="card mt-4">
        <div class="card-header bg-success text-white">
          <h6 class="mb-0"><i class="fa fa-eye"></i> Pratinjau Tanda Tangan</h6>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <div class="border rounded p-3 bg-light">
                <div class="text-center"><strong>Mengetahui</strong><br>Ketua PN Watampone</div>
                <div style="height:70px"></div>
                <div class="text-center"><strong><?= htmlspecialchars($ketua_nama ?: '(............................)') ?></strong></div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="border rounded p-3 bg-light">
                <div class="text-center"><strong>Mengetahui</strong><br>Wakil Ketua PN</div>
                <div style="height:70px"></div>
                <div class="text-center"><strong><?= htmlspecialchars($wakil_nama ?: '(............................)') ?></strong></div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="border rounded p-3 bg-light">
                <div class="text-center"><strong>Disetujui</strong><br>Panitera</div>
                <div style="height:70px"></div>
                <div class="text-center"><strong><?= htmlspecialchars($panitera_nama ?: '(............................)') ?></strong></div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="border rounded p-3 bg-light">
                <div class="text-center"><strong>Diperiksa</strong><br>Panmud Hukum</div>
                <div style="height:70px"></div>
                <div class="text-center"><strong><?= htmlspecialchars($panmud_nama ?: '(............................)') ?></strong></div>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Info Card -->
      <div class="card mt-4">
        <div class="card-header bg-info text-white">
          <h6 class="mb-0"><i class="fa fa-info-circle"></i> Informasi Penggunaan</h6>
        </div>
        <div class="card-body">
          <ul class="mb-0">
            <li><strong>Ketua/Wakil Ketua:</strong> Nama akan muncul di surat peminjaman sesuai pilihan penandatangan</li>
            <li><strong>Panitera:</strong> Nama akan muncul di bukti pengembalian pada bagian "Disetujui"</li>
            <li><strong>Panmud Hukum:</strong> Nama akan muncul di bukti pengembalian pada bagian "Diperiksa"</li>
            <li><strong>Format:</strong> Gunakan gelar lengkap (contoh: H. Nama, S.H., M.H.)</li>
          </ul>
        </div>
      </div>
      
    </div>
  </div>
</div>

<!-- Footer -->
<footer class="bg-primary text-white text-center py-3 mt-5">
  <div class="container">
    <p class="mb-0">©2025 by Pn Watampone, Dibuat oleh Fahrurrasyid, A.Md.T CPNS Mahkamah Agung RI Angkatan 2024</p>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
