<?php
// Script untuk menambahkan footer ke semua file PHP

$footer = '
<!-- Footer -->
<footer class="bg-primary text-white text-center py-3 mt-5">
  <div class="container">
    <p class="mb-0">©2025 by Pn Watampone, Dibuat oleh Fahrurrasyid, A.Md.T CPNS Mahkamah Agung RI Angkatan 2024</p>
  </div>
</footer>

';

// File-file yang perlu ditambahkan footer
$files = [
    'bukti.php',
    'welcome.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        $content = file_get_contents($file);
        
        // Check if footer already exists
        if (strpos($content, '©2025 by Pn Watampone') === false) {
            // Find </body> tag and add footer before it
            $content = str_replace('</body>', $footer . '</body>', $content);
            
            // Write back to file
            file_put_contents($file, $content);
            echo "Footer added to: $file\n";
        } else {
            echo "Footer already exists in: $file\n";
        }
    } else {
        echo "File not found: $file\n";
    }
}

echo "Footer addition completed!\n";
?>
