<?php
/**
 * Debug koneksi SIPP langsung
 */

$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306
];

echo "<h3>Test Koneksi SIPP Server</h3>";
echo "<p><strong>Host:</strong> {$sipp_config['host']}</p>";
echo "<p><strong>Database:</strong> {$sipp_config['dbname']}</p>";
echo "<p><strong>Port:</strong> {$sipp_config['port']}</p>";

try {
    echo "<h4>Step 1: Testing basic connection...</h4>";
    
    $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
    
    echo "<p>DSN: <code>$dsn</code></p>";
    
    $pdo = new PDO($dsn, $sipp_config['username'], $sipp_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_TIMEOUT => 10
    ]);
    
    echo "<p style='color: green;'>✓ Connection successful!</p>";
    
    echo "<h4>Step 2: Testing table access...</h4>";
    
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<p>Found " . count($tables) . " tables:</p>";
    echo "<ul>";
    foreach($tables as $table) {
        echo "<li>$table</li>";
        if($table == 'arsip') {
            echo " <strong>(Target table found!)</strong>";
        }
    }
    echo "</ul>";
    
    echo "<h4>Step 3: Testing arsip table...</h4>";
    
    if(in_array('arsip', $tables)) {
        $stmt = $pdo->query("SELECT COUNT(*) as total FROM arsip");
        $result = $stmt->fetch();
        echo "<p style='color: green;'>✓ Arsip table accessible!</p>";
        echo "<p><strong>Total records:</strong> " . number_format($result['total']) . "</p>";
        
        // Sample data
        echo "<h4>Step 4: Sample data...</h4>";
        $stmt = $pdo->query("SELECT * FROM arsip LIMIT 3");
        $samples = $stmt->fetchAll();
        
        if($samples) {
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr>";
            foreach(array_keys($samples[0]) as $column) {
                echo "<th style='padding: 8px; background: #f0f0f0;'>$column</th>";
            }
            echo "</tr>";
            
            foreach($samples as $row) {
                echo "<tr>";
                foreach($row as $value) {
                    echo "<td style='padding: 8px;'>" . htmlspecialchars($value) . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p style='color: orange;'>⚠ Table exists but no data found</p>";
        }
        
    } else {
        echo "<p style='color: red;'>✗ Arsip table not found!</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Connection failed!</p>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>Error Code:</strong> " . $e->getCode() . "</p>";
    
    // Specific error analysis
    if (strpos($e->getMessage(), 'Connection refused') !== false) {
        echo "<p><strong>Analysis:</strong> MySQL server might not be running on port 3306</p>";
    } elseif (strpos($e->getMessage(), 'Access denied') !== false) {
        echo "<p><strong>Analysis:</strong> Username/password incorrect or user doesn't have permission</p>";
    } elseif (strpos($e->getMessage(), 'Unknown database') !== false) {
        echo "<p><strong>Analysis:</strong> Database 'sippbaco' doesn't exist</p>";
    } elseif (strpos($e->getMessage(), 'timeout') !== false) {
        echo "<p><strong>Analysis:</strong> Connection timeout - firewall or network issue</p>";
    }
    
    echo "<h4>Troubleshooting Steps:</h4>";
    echo "<ol>";
    echo "<li>Check if MySQL service is running on 192.168.1.240</li>";
    echo "<li>Verify database name 'sippbaco' exists</li>";
    echo "<li>Check username 'pnwtp' and password</li>";
    echo "<li>Verify user has SELECT permission on database</li>";
    echo "<li>Check firewall settings on port 3306</li>";
    echo "</ol>";
}
?>
