<?php
/**
 * Debug Simple - Test koneksi SIPP vs Arsip.php
 */

echo "<h3>Test Koneksi SIPP - Perbandingan</h3>";

// Konfigurasi sama dengan arsip.php
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306
];

echo "<h4>1. Test koneksi seperti di arsip.php</h4>";
try {
    $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
    $sipp_db = new PDO($dsn, $sipp_config['username'], $sipp_config['password']);
    $sipp_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<div style='color: green;'>✅ Koneksi arsip.php style: BERHASIL</div>";
    
    // Test query simple seperti di arsip.php
    $stmt = $sipp_db->prepare("SELECT COUNT(*) FROM arsip WHERE 1=1");
    $stmt->execute();
    $count = $stmt->fetchColumn();
    echo "<div style='color: green;'>✅ Data count (arsip.php style): " . number_format($count) . " records</div>";
    
    // Test ambil 1 record
    $stmt = $sipp_db->prepare("SELECT * FROM arsip LIMIT 1");
    $stmt->execute();
    $sample = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<div style='color: blue;'>📋 Sample columns: " . implode(', ', array_keys($sample ?: [])) . "</div>";
    
} catch (PDOException $e) {
    echo "<div style='color: red;'>❌ Koneksi arsip.php style: GAGAL - " . $e->getMessage() . "</div>";
}

echo "<h4>2. Test koneksi seperti di sync-sipp-to-sqlite.php (UPDATED)</h4>";
function connectSipp($config) {
    try {
        $dsn = "mysql:host={$config['host']};port={$config['port']};dbname={$config['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['username'], $config['password']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        throw new Exception("SIPP Connection Error: " . $e->getMessage());
    }
}

try {
    $sipp_pdo = connectSipp($sipp_config);
    
    echo "<div style='color: green;'>✅ Koneksi sync style (UPDATED): BERHASIL</div>";
    
    // Test query seperti di sync yang sudah diupdate
    $sql = "SELECT * FROM arsip ORDER BY nomor_perkara LIMIT 5";
    $stmt = $sipp_pdo->prepare($sql);
    $stmt->execute();
    $count = 0;
    while ($row = $stmt->fetch()) {
        $count++;
    }
    echo "<div style='color: green;'>✅ Test fetch 5 records: BERHASIL ($count records)</div>";
    
} catch (Exception $e) {
    echo "<div style='color: red;'>❌ Koneksi sync style: GAGAL - " . $e->getMessage() . "</div>";
}

echo "<h4>3. Test SQLite Path</h4>";
$sqlite_path = 'data/sipp_sync.sqlite';
echo "<div>SQLite path: <code>" . realpath(dirname($sqlite_path)) . "/" . basename($sqlite_path) . "</code></div>";

if (!is_dir('data')) {
    echo "<div style='color: orange;'>⚠️ Directory 'data' tidak ada, akan dibuat</div>";
    mkdir('data', 0755, true);
} else {
    echo "<div style='color: green;'>✅ Directory 'data' sudah ada</div>";
}

if (file_exists($sqlite_path)) {
    echo "<div style='color: green;'>✅ SQLite file sudah ada (" . number_format(filesize($sqlite_path)) . " bytes)</div>";
} else {
    echo "<div style='color: orange;'>⚠️ SQLite file belum ada</div>";
}

echo "<h4>4. Kesimpulan Perbedaan</h4>";
echo "<div><strong>Sebelum fix:</strong></div>";
echo "<div>- Sync menggunakan PDO options tambahan (ATTR_DEFAULT_FETCH_MODE, ATTR_EMULATE_PREPARES)</div>";
echo "<div>- Query dengan filter kompleks (WHERE nomor_perkara IS NOT NULL AND nomor_perkara != '')</div>";
echo "<div><br><strong>Setelah fix:</strong></div>";
echo "<div>- Sync menggunakan koneksi yang sama persis dengan arsip.php</div>";
echo "<div>- Query sederhana seperti arsip.php (SELECT * FROM arsip)</div>";
echo "<div><br><strong>Silakan test sync lagi!</strong></div>";
?>
