# Panduan Hosting di Rumahweb.com

## 🚨 **Masalah Utama:**
Error: `Can't connect to server on '192.168.1.240'` terjadi karena **IP 192.168.1.240 adalah IP lokal** yang hanya bisa diakses dari jaringan lokal, bukan dari server hosting.

## ✅ **Solusi untuk Hosting:**

### **Opsi 1: Mode SQLite Offline (Recommended)**

#### **Step 1: Upload Data SQLite**
1. **Download file SQLite** dari localhost:
   ```
   /xampp/htdocs/pinjam-berkas/data/sipp_sync.sqlite
   ```

2. **Upload ke hosting** di folder yang sama:
   ```
   /public_html/pinjam-berkas/data/sipp_sync.sqlite
   ```

#### **Step 2: Gunakan Menu Auto-Fallback**
- Gunakan menu **"Lihat Arsip (Auto)"** yang akan otomatis menggunakan SQLite
- Sistem akan detect SIPP tidak tersedia dan fallback ke SQLite

#### **Step 3: Update Data Berkala**
- Sync data di localhost saat terhubung ke jaringan kantor
- Upload file SQLite yang sudah diupdate ke hosting

---

### **Opsi 2: Expose SIPP Server (Advanced)**

#### **A. VPN Solution:**
1. Setup VPN server di kantor
2. Connect hosting ke VPN (jika hosting support)
3. Akses SIPP melalui VPN

#### **B. Public IP + Port Forwarding:**
1. Berikan IP public untuk server SIPP
2. Configure port forwarding di router
3. Update konfigurasi dengan IP public

#### **C. SSH Tunnel:**
1. Setup SSH tunnel dari hosting ke kantor
2. Route koneksi MySQL melalui tunnel

---

### **Opsi 3: Hybrid Solution**

#### **Setup Automated Sync:**
1. **Cron job di localhost** untuk sync SIPP → SQLite
2. **Auto upload** SQLite file ke hosting
3. **Hosting selalu menggunakan** data SQLite terbaru

---

## 🔧 **Quick Fix untuk Sekarang:**

### **1. Download SQLite dari Localhost**
```bash
# Path file di XAMPP
C:\xampp\htdocs\pinjam-berkas\data\sipp_sync.sqlite
```

### **2. Upload ke Hosting**
Upload file tersebut ke:
```
/public_html/pinjam-berkas/data/sipp_sync.sqlite
```

### **3. Test Auto-Fallback**
Akses:
```
https://pnwtp.site/pinjam-berkas/arsip-auto.php
```

### **4. Verifikasi Data**
Check:
```
https://pnwtp.site/pinjam-berkas/arsip-sqlite.php
```

---

## 📋 **Files yang Telah Dibuat:**

1. **arsip-auto.php** - Auto-detect SIPP/SQLite
2. **Updated menu dropdown** - Tambah opsi "Auto"
3. **Notifikasi offline mode** - Info ketika fallback ke SQLite

---

## 🎯 **Recommended Workflow:**

### **Development (Localhost):**
1. Gunakan SIPP langsung untuk development
2. Sync ke SQLite secara berkala
3. Test fitur dengan SQLite

### **Production (Hosting):**
1. Upload SQLite file dari localhost
2. Gunakan mode SQLite offline
3. Update data manual saat diperlukan

### **Maintenance:**
1. Sync data di localhost mingguan/bulanan
2. Upload SQLite file baru ke hosting
3. Users tetap bisa akses data terbaru

---

## 🚀 **Immediate Action:**

1. ✅ **Upload SQLite file** dari localhost ke hosting
2. ✅ **Test arsip-auto.php** di hosting
3. ✅ **Verifikasi data tersedia** di SQLite mode
4. ✅ **Inform users** menggunakan menu "Lihat Arsip (Auto)"

**Status:** Ready untuk production dengan SQLite offline mode! 🎯
