# FITUR SORTING TABEL ARSIP SIPP

## Deskripsi
Menambahkan fitur pengurutan (ascending/descending) pada tabel arsip SIPP untuk memudahkan pengguna mencari dan mengurutkan data.

## Fitur yang Ditambahkan

### 1. Sorting pada Kolom Header
Setiap kolom header sekarang dapat diklik untuk mengurutkan data:
- **Nomor Arsip** - Sort berdasarkan `nomor_arsip`
- **Nomor Ruang** - Sort berdasarkan `no_ruang`
- **Nomor Rak/Lemari** - Sort berdasarkan `no_lemari`
- **Nomor Tingkat/Laci** - Sort berdasarkan `no_rak`
- **Nomor Boks** - Sort berdasarkan `no_berkas`
- **Nomor Perkara** - Sort berdasarkan `nomor_perkara`
- **Tanggal Masuk** - Sort berdasarkan `tanggal_masuk_arsip`

### 2. Indikator Visual
- Icon panah naik (▲) untuk sorting ASC (ascending)
- Icon panah turun (▼) untuk sorting DESC (descending)  
- Icon panah dua arah (↕) untuk kolom yang belum di-sort

### 3. Toggle Behavior
- Klik pertama pada kolom = ASC
- Klik kedua pada kolom yang sama = DESC
- Klik pada kolom lain = ASC untuk kolom baru

### 4. URL Parameters
- `sort` - Nama kolom untuk sorting
- `dir` - Arah sorting (ASC/DESC)
- Parameter lain (search, pagination) tetap dipertahankan

## Implementasi Teknis

### 1. Validasi Keamanan
```php
// Validasi kolom sorting - hanya kolom yang diizinkan
$allowed_sorts = [
    'id' => 'id',
    'nomor_arsip' => 'nomor_arsip', 
    'no_ruang' => 'no_ruang',
    'no_lemari' => 'no_lemari',
    'no_rak' => 'no_rak', 
    'no_berkas' => 'no_berkas',
    'nomor_perkara' => 'nomor_perkara',
    'tanggal_masuk_arsip' => 'tanggal_masuk_arsip'
];

// Validasi arah sorting
if (!in_array($dir, ['ASC', 'DESC'])) {
    $dir = 'DESC';
}
```

### 2. Helper Functions
```php
// Membuat URL untuk sorting
function sort_url($column) {
    global $sort, $dir, $q;
    $new_dir = ($sort === $column && $dir === 'ASC') ? 'DESC' : 'ASC';
    $params = ['sort' => $column, 'dir' => $new_dir];
    if ($q) $params['q'] = $q;
    return '?' . http_build_query($params);
}

// Menampilkan icon sorting
function sort_icon($column) {
    global $sort, $dir;
    if ($sort !== $column) return '<i class="fa fa-sort text-muted"></i>';
    return $dir === 'ASC' ? '<i class="fa fa-sort-up text-white"></i>' : '<i class="fa fa-sort-down text-white"></i>';
}
```

### 3. CSS Styling
```css
.table thead th{
    background:#28a745;
    color:white;
    font-weight:600;
    border:none;
    padding:12px 8px;
    text-align:center;
    font-size:13px;
    cursor:pointer;      /* Menunjukkan bahwa header dapat diklik */
    user-select:none     /* Mencegah text selection */
}
.table thead th:hover{
    background:#1e7e34   /* Efek hover untuk feedback visual */
}
.table thead th a{
    color:white;
    text-decoration:none;
    display:block;
    width:100%;
    height:100%
}
```

### 4. Query Database
```php
// SQL dengan ORDER BY dinamis
$sql .= " ORDER BY " . $allowed_sorts[$sort] . " " . $dir . " LIMIT $limit OFFSET $offset";
```

## Cara Penggunaan

1. **Mengurutkan Data:**
   - Klik pada header kolom yang ingin diurutkan
   - Data akan terurut ASC (A-Z, 1-9, terlama-terbaru)
   - Klik lagi untuk DESC (Z-A, 9-1, terbaru-terlama)

2. **Kombinasi dengan Fitur Lain:**
   - Sorting bekerja bersamaan dengan pencarian
   - Pagination mempertahankan urutan sorting
   - Parameter URL dapat dibookmark

3. **Default Behavior:**
   - Default sorting: ID DESC (data terbaru di atas)
   - Jika parameter sorting invalid, akan fallback ke default

## Contoh URL
```
arsip.php?sort=nomor_perkara&dir=ASC          # Urutkan nomor perkara A-Z
arsip.php?sort=tanggal_masuk_arsip&dir=DESC   # Urutkan tanggal terbaru
arsip.php?q=2024&sort=no_ruang&dir=ASC        # Cari "2024" + urutkan ruang
```

## Files Modified
- `arsip.php`: Implementasi lengkap fitur sorting

## Date Created
September 1, 2025
