# Use Case Diagram (Versi Vertikal) - Sistem Peminjaman Berkas PN Watampone

## Versi Vertikal dengan Layout Seimbang

```plantuml
@startuml
!theme cerulean-outline
title Use Case Diagram - Sistem Peminjaman Berkas PN Watampone

' Menghilangkan direction untuk layout vertikal default
skinparam usecase {
    BackgroundColor lightblue
    BorderColor darkblue
}

actor "Admin" as Admin
actor "Petugas" as Petugas

package "Sistem Peminjaman Berkas" {
  
  package "Autentikasi" {
    usecase "Login" as UC1
    usecase "Logout" as UC2
  }
  
  package "Manajemen Data" {
    usecase "Tambah Peminjaman" as UC3
    usecase "Lihat Data" as UC4
    usecase "Edit Data" as UC5
    usecase "Hapus Data" as UC6
  }
  
  package "Operasional" {
    usecase "Perpanjang" as UC7
    usecase "Kembalikan" as UC8
  }
  
  package "Dokumentasi" {
    usecase "Cetak Surat" as UC9
    usecase "Cetak Bukti" as UC10
  }
  
  package "Arsip & Laporan" {
    usecase "Cari Arsip" as UC11
    usecase "Sync Data" as UC12
    usecase "Lihat Laporan" as UC13
  }
  
  package "Administrasi" {
    usecase "Kelola User" as UC14
    usecase "Backup Data" as UC15
    usecase "Pengaturan" as UC16
  }
}

actor "Database SIPP" as SIPP

' Petugas connections (kiri)
Petugas --> UC1
Petugas --> UC2
Petugas --> UC3
Petugas --> UC4
Petugas --> UC7
Petugas --> UC8
Petugas --> UC9
Petugas --> UC10
Petugas --> UC11
Petugas --> UC12
Petugas --> UC13

' Admin connections (kanan)
Admin --> UC1
Admin --> UC2
Admin --> UC3
Admin --> UC4
Admin --> UC5
Admin --> UC6
Admin --> UC7
Admin --> UC8
Admin --> UC9
Admin --> UC10
Admin --> UC11
Admin --> UC12
Admin --> UC13
Admin --> UC14
Admin --> UC15
Admin --> UC16

' External system
UC11 --> SIPP
UC12 --> SIPP

' Include relationships
UC3 ..> UC11 : <<include>>
UC10 ..> UC8 : <<include>>

note left of Petugas
  Petugas:
  - Input & operasional
  - Cetak dokumen
  - Akses laporan
end note

note right of Admin
  Admin:
  - Semua akses petugas
  - Edit/hapus data
  - Kelola user & sistem
end note

note bottom of SIPP
  Database SIPP
  Server: 192.168.1.240
  Untuk data arsip perkara
end note

@enduml
```

## Struktur 16 Use Cases (6 Package):

### 🔐 **Autentikasi (2)**
- Login / Logout sistem

### 📋 **Manajemen Data (4)**
- Tambah, Lihat, Edit*, Hapus* peminjaman
- (*) Admin only

### 🔄 **Operasional (2)**
- Perpanjang masa pinjam
- Kembalikan berkas

### 🖨️ **Dokumentasi (2)**
- Cetak surat peminjaman
- Cetak bukti pengembalian

### 📊 **Arsip & Laporan (3)**
- Cari arsip (autocomplete)
- Sinkronisasi data SIPP
- Lihat laporan & notifikasi

### ⚙️ **Administrasi (3)**
- Kelola user accounts
- Backup/restore database
- Pengaturan sistem

## Copy Kode Vertikal Ini: