# Use Case Diagram (Versi Singkat) - Sistem Peminjaman Berkas PN Watampone

## Versi Sederhana dengan Fitur Utama Saja

```plantuml
@startuml
!theme plain
title Use Case Diagram - Sistem Peminjaman Berkas PN Watampone (Versi Singkat)

left to right direction

actor "Petugas" as Petugas
actor "Admin" as Admin
actor "Database SIPP" as SIPP

rectangle "Sistem Peminjaman Berkas" {
  
  ' Autentikasi
  usecase "Login" as UC1
  usecase "Logout" as UC2
  
  ' Manajemen Peminjaman
  usecase "Tambah Peminjaman" as UC3
  usecase "Lihat Data" as UC4
  usecase "Edit Data" as UC5
  usecase "Hapus Data" as UC6
  
  ' Operasional
  usecase "Perpanjang" as UC7
  usecase "Kembalikan Berkas" as UC8
  
  ' Cetak
  usecase "Cetak Surat" as UC9
  usecase "Cetak Bukti" as UC10
  
  ' Arsip
  usecase "Cari Arsip" as UC11
  usecase "Sync Data" as UC12
  
  ' Laporan
  usecase "Lihat Laporan" as UC13
  usecase "Lihat Notifikasi" as UC14
  
  ' Admin Only
  usecase "Kelola User" as UC15
  usecase "Backup Data" as UC16
  usecase "Pengaturan" as UC17
}

' Petugas - Akses Operasional
Petugas --> UC1
Petugas --> UC2
Petugas --> UC3
Petugas --> UC4
Petugas --> UC7
Petugas --> UC8
Petugas --> UC9
Petugas --> UC10
Petugas --> UC11
Petugas --> UC12
Petugas --> UC13
Petugas --> UC14

' Admin - Akses Penuh
Admin --> UC1
Admin --> UC2
Admin --> UC3
Admin --> UC4
Admin --> UC5
Admin --> UC6
Admin --> UC7
Admin --> UC8
Admin --> UC9
Admin --> UC10
Admin --> UC11
Admin --> UC12
Admin --> UC13
Admin --> UC14
Admin --> UC15
Admin --> UC16
Admin --> UC17

' External System
UC11 --> SIPP : <<access>>
UC12 --> SIPP : <<sync>>

' Key Relationships
UC3 ..> UC11 : <<include>>
UC10 ..> UC8 : <<include>>

note right of Admin
  Admin: Akses penuh
  - Edit/Hapus data
  - Kelola user
  - Backup system
end note

note left of Petugas
  Petugas: Akses operasional
  - Input peminjaman
  - Perpanjang/Kembalikan
  - Cetak dokumen
end note

note bottom of SIPP
  Database SIPP eksternal
  (192.168.1.240)
end note

@enduml
```

## Fitur Utama (17 Use Cases)

### 🔐 **Autentikasi (2)**
- Login / Logout

### 📋 **Manajemen Data (4)**
- Tambah, Lihat, Edit*, Hapus* Peminjaman
- (*) Admin only

### 🔄 **Operasional (2)**
- Perpanjang Peminjaman
- Kembalikan Berkas

### 🖨️ **Cetak (2)**
- Cetak Surat Peminjaman
- Cetak Bukti Pengembalian

### 📁 **Arsip (2)**
- Cari Data Arsip (SIPP)
- Sinkronisasi Data

### 📊 **Monitoring (2)**
- Lihat Laporan
- Lihat Notifikasi

### ⚙️ **Admin (3)**
- Kelola User
- Backup Data
- Pengaturan Sistem

## Perbedaan Role

**Petugas (14 akses)**: Operasional harian
**Admin (17 akses)**: Semua fitur + manajemen

## Copy Kode Singkat Ini ke PlantUML Editor: