# Use Case Diagram (Versi Super Singkat) - Sistem Peminjaman Berkas PN Watampone

## Versi Minimal dengan Layout Rapi

```plantuml
@startuml
!theme cerulean-outline
title Use Case Diagram - Sistem Peminjaman Berkas PN Watampone

actor "Admin" as Admin
actor "Petugas" as Petugas

package "Sistem Peminjaman Berkas" {
  usecase "Login" as Login
  usecase "Kelola Peminjaman" as Kelola
  usecase "Perpanjang & Kembalikan" as Proses
  usecase "Cetak Dokumen" as Cetak
  usecase "Cari Arsip" as Arsip
  usecase "Lihat Laporan" as Laporan
  usecase "Admin Panel" as AdminPanel
}

actor "Database SIPP" as SIPP

' Petugas connections
Petugas --> Login
Petugas --> Kelola
Petugas --> Proses
Petugas --> Cetak
Petugas --> Arsip
Petugas --> Laporan

' Admin connections (all + admin features)
Admin --> Login
Admin --> Kelola
Admin --> Proses
Admin --> Cetak
Admin --> Arsip
Admin --> Laporan
Admin --> AdminPanel

' External system
Arsip --> SIPP

note top of Admin : Akses penuh sistem
note top of Petugas : Akses operasional
note right of SIPP : Server 192.168.1.240

@enduml
```

## Penjelasan 7 Use Case Utama:

### 🔐 **Login** 
Autentikasi sistem (admin/petugas)

### 📋 **Kelola Peminjaman**
- Tambah peminjaman baru
- Lihat/edit data (admin dapat edit/hapus)

### 🔄 **Perpanjang & Kembalikan**
- Perpanjang masa pinjam
- Proses pengembalian berkas

### 🖨️ **Cetak Dokumen**
- Cetak surat peminjaman
- Cetak bukti pengembalian + QR

### 📁 **Cari Arsip**
- Autocomplete nomor perkara
- Akses database SIPP

### 📊 **Lihat Laporan**
- Laporan statistik
- Notifikasi keterlambatan

### ⚙️ **Admin Panel** (Admin Only)
- Kelola user accounts
- Backup/restore database
- Pengaturan sistem

## Copy Kode Super Singkat Ini: