<?php
// Test script untuk fitur tanggal tanda tangan manual
include 'db.php';

echo "<h2>Test Fitur Tanggal Tanda Tangan Manual</h2>";

// 1. Test cek kolom tanggal_tanda_tangan
echo "<h3>1. Cek Struktur Tabel</h3>";
$columns = $db->query("PRAGMA table_info(peminjaman)")->fetchAll();
$foundColumn = false;
foreach ($columns as $column) {
    if ($column['name'] === 'tanggal_tanda_tangan') {
        $foundColumn = true;
        echo "✅ Kolom 'tanggal_tanda_tangan' ditemukan<br>";
        echo "- Type: " . $column['type'] . "<br>";
        echo "- Nullable: " . ($column['notnull'] ? 'NO' : 'YES') . "<br>";
        break;
    }
}
if (!$foundColumn) {
    echo "❌ Kolom 'tanggal_tanda_tangan' tidak ditemukan<br>";
}

// 2. Test insert data dengan tanggal tanda tangan
echo "<h3>2. Test Insert Data dengan Tanggal Tanda Tangan</h3>";
try {
    $testData = [
        'nama' => 'Test User Manual TTD',
        'jabatan' => 'Test Jabatan',
        'tujuan' => 'Test tujuan dengan tanggal manual',
        'nomor_perkara' => 'TEST/001/2025/PN.Wtp',
        'nama_pihak' => 'Test Pihak',
        'nama_pihak_lain' => '',
        'tanggal_ambil' => '2025-01-24',
        'tanggal_kembali' => '2025-01-27',
        'penandatangan' => 'ketua',
        'tanggal_tanda_tangan' => '2025-01-25' // Manual date
    ];
    
    $stmt = $db->prepare("INSERT INTO peminjaman (nama, jabatan, tujuan, nomor_perkara, nama_pihak, nama_pihak_lain, tanggal_ambil, tanggal_kembali, penandatangan, tanggal_tanda_tangan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $result = $stmt->execute([
        $testData['nama'], $testData['jabatan'], $testData['tujuan'], 
        $testData['nomor_perkara'], $testData['nama_pihak'], $testData['nama_pihak_lain'],
        $testData['tanggal_ambil'], $testData['tanggal_kembali'], $testData['penandatangan'],
        $testData['tanggal_tanda_tangan']
    ]);
    
    if ($result) {
        $testId = $db->lastInsertId();
        echo "✅ Insert berhasil dengan ID: $testId<br>";
        echo "- Tanggal tanda tangan: " . $testData['tanggal_tanda_tangan'] . "<br>";
    } else {
        echo "❌ Insert gagal<br>";
    }
} catch (Exception $e) {
    echo "❌ Error insert: " . $e->getMessage() . "<br>";
}

// 3. Test insert data tanpa tanggal tanda tangan (NULL)
echo "<h3>3. Test Insert Data tanpa Tanggal Tanda Tangan</h3>";
try {
    $testData2 = [
        'nama' => 'Test User Auto TTD',
        'jabatan' => 'Test Jabatan',
        'tujuan' => 'Test tujuan tanpa tanggal manual',
        'nomor_perkara' => 'TEST/002/2025/PN.Wtp',
        'nama_pihak' => 'Test Pihak 2',
        'nama_pihak_lain' => '',
        'tanggal_ambil' => '2025-01-24',
        'tanggal_kembali' => '2025-01-27',
        'penandatangan' => 'wakil',
        'tanggal_tanda_tangan' => null // Auto date
    ];
    
    $stmt = $db->prepare("INSERT INTO peminjaman (nama, jabatan, tujuan, nomor_perkara, nama_pihak, nama_pihak_lain, tanggal_ambil, tanggal_kembali, penandatangan, tanggal_tanda_tangan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $result = $stmt->execute([
        $testData2['nama'], $testData2['jabatan'], $testData2['tujuan'], 
        $testData2['nomor_perkara'], $testData2['nama_pihak'], $testData2['nama_pihak_lain'],
        $testData2['tanggal_ambil'], $testData2['tanggal_kembali'], $testData2['penandatangan'],
        $testData2['tanggal_tanda_tangan']
    ]);
    
    if ($result) {
        $testId2 = $db->lastInsertId();
        echo "✅ Insert berhasil dengan ID: $testId2<br>";
        echo "- Tanggal tanda tangan: NULL (akan menggunakan tanggal saat print)<br>";
    } else {
        echo "❌ Insert gagal<br>";
    }
} catch (Exception $e) {
    echo "❌ Error insert: " . $e->getMessage() . "<br>";
}

// 4. Test query data
echo "<h3>4. Test Query Data Test</h3>";
try {
    $stmt = $db->prepare("SELECT id, nama, nomor_perkara, tanggal_tanda_tangan FROM peminjaman WHERE nomor_perkara LIKE 'TEST/%' ORDER BY id DESC LIMIT 5");
    $stmt->execute();
    $testRows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($testRows) > 0) {
        echo "✅ Data test ditemukan:<br>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Nama</th><th>Nomor Perkara</th><th>Tanggal TTD</th><th>Status TTD</th></tr>";
        foreach ($testRows as $row) {
            $statusTtd = empty($row['tanggal_tanda_tangan']) ? 'Auto (saat print)' : 'Manual: ' . $row['tanggal_tanda_tangan'];
            echo "<tr>";
            echo "<td>" . $row['id'] . "</td>";
            echo "<td>" . htmlspecialchars($row['nama']) . "</td>";
            echo "<td>" . htmlspecialchars($row['nomor_perkara']) . "</td>";
            echo "<td>" . ($row['tanggal_tanda_tangan'] ?: 'NULL') . "</td>";
            echo "<td>" . $statusTtd . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "❌ Tidak ada data test<br>";
    }
} catch (Exception $e) {
    echo "❌ Error query: " . $e->getMessage() . "<br>";
}

// 5. Simulasi output print
echo "<h3>5. Simulasi Output Print</h3>";
if (isset($testId) && isset($testId2)) {
    echo "<strong>Test 1 - Dengan tanggal manual:</strong><br>";
    $stmt = $db->prepare("SELECT tanggal_tanda_tangan FROM peminjaman WHERE id = ?");
    $stmt->execute([$testId]);
    $row1 = $stmt->fetch(PDO::FETCH_ASSOC);
    $tanggalPrint1 = !empty($row1['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row1['tanggal_tanda_tangan'])) : date('d-m-Y');
    echo "Output: Watampone, $tanggalPrint1<br><br>";
    
    echo "<strong>Test 2 - Tanggal otomatis:</strong><br>";
    $stmt = $db->prepare("SELECT tanggal_tanda_tangan FROM peminjaman WHERE id = ?");
    $stmt->execute([$testId2]);
    $row2 = $stmt->fetch(PDO::FETCH_ASSOC);
    $tanggalPrint2 = !empty($row2['tanggal_tanda_tangan']) ? date('d-m-Y', strtotime($row2['tanggal_tanda_tangan'])) : date('d-m-Y');
    echo "Output: Watampone, $tanggalPrint2<br>";
}

echo "<h3>6. Cleanup (Hapus Data Test)</h3>";
try {
    $stmt = $db->prepare("DELETE FROM peminjaman WHERE nomor_perkara LIKE 'TEST/%'");
    $result = $stmt->execute();
    if ($result) {
        echo "✅ Data test berhasil dibersihkan<br>";
    }
} catch (Exception $e) {
    echo "❌ Error cleanup: " . $e->getMessage() . "<br>";
}

echo "<h3>✅ Test Selesai</h3>";
echo "<p><strong>Kesimpulan:</strong><br>";
echo "- Kolom tanggal_tanda_tangan berhasil ditambahkan<br>";
echo "- Form input/edit dapat menerima tanggal manual<br>";
echo "- Jika tanggal kosong/NULL, sistem akan menggunakan tanggal saat print<br>";
echo "- Print output akan menampilkan tanggal sesuai pilihan user</p>";

echo "<p><a href='index.php'>← Kembali ke Halaman Utama</a></p>";
?>
