<?php
// Konfigurasi koneksi database SIPP
// File ini berisi pengaturan untuk mengakses database SIPP

if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Konfigurasi database SIPP
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306,
    'charset' => 'utf8mb4'
];

/**
 * Fungsi untuk membuat koneksi ke database SIPP
 * @return PDO|null Objek PDO untuk koneksi database atau null jika gagal
 */
function connectSipp() {
    global $sipp_config;
    
    try {
        $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset={$sipp_config['charset']}";
        
        $pdo = new PDO($dsn, $sipp_config['username'], $sipp_config['password'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES {$sipp_config['charset']}"
        ]);
        
        return $pdo;
        
    } catch (PDOException $e) {
        error_log("SIPP Database Connection Error: " . $e->getMessage());
        return null;
    }
}

/**
 * Fungsi untuk testing koneksi database SIPP
 * @return array Status koneksi dan pesan
 */
function testSippConnection() {
    $sipp_db = connectSipp();
    
    if ($sipp_db === null) {
        return [
            'success' => false,
            'message' => 'Gagal terhubung ke database SIPP'
        ];
    }
    
    try {
        // Test query sederhana
        $stmt = $sipp_db->query("SELECT 1");
        $result = $stmt->fetch();
        
        if ($result) {
            return [
                'success' => true,
                'message' => 'Berhasil terhubung ke database SIPP'
            ];
        } else {
            return [
                'success' => false,
                'message' => 'Koneksi berhasil tetapi tidak dapat menjalankan query'
            ];
        }
        
    } catch (PDOException $e) {
        return [
            'success' => false,
            'message' => 'Error query: ' . $e->getMessage()
        ];
    }
}

/**
 * Fungsi untuk mendapatkan daftar tabel dari database SIPP
 * @return array|false Daftar tabel atau false jika gagal
 */
function getSippTables() {
    $sipp_db = connectSipp();
    
    if ($sipp_db === null) {
        return false;
    }
    
    try {
        $stmt = $sipp_db->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        return $tables;
        
    } catch (PDOException $e) {
        error_log("Error getting SIPP tables: " . $e->getMessage());
        return false;
    }
}

/**
 * Fungsi untuk mendapatkan struktur tabel arsip
 * @return array|false Struktur kolom tabel atau false jika gagal
 */
function getArsipTableStructure() {
    $sipp_db = connectSipp();
    
    if ($sipp_db === null) {
        return false;
    }
    
    try {
        $stmt = $sipp_db->query("DESCRIBE arsip");
        $columns = $stmt->fetchAll();
        return $columns;
        
    } catch (PDOException $e) {
        error_log("Error getting arsip table structure: " . $e->getMessage());
        return false;
    }
}
?>
