<?php
// Simple test for sorting functionality
$test_get = [
    'sort' => 'nomor_perkara',
    'dir' => 'ASC',
    'q' => '',
    'page' => '1'
];

// Simulate $_GET
$_GET = $test_get;

// Test variables
$sort = $_GET['sort'] ?? 'id';
$dir = strtoupper($_GET['dir'] ?? 'DESC');
$q = trim($_GET['q'] ?? '');

// Validate sort direction
if (!in_array($dir, ['ASC', 'DESC'])) {
    $dir = 'DESC';
}

// Validate sort column
$allowed_sorts = [
    'id' => 'id',
    'nomor_arsip' => 'nomor_arsip', 
    'no_ruang' => 'no_ruang',
    'no_lemari' => 'no_lemari',
    'no_rak' => 'no_rak', 
    'no_berkas' => 'no_berkas',
    'nomor_perkara' => 'nomor_perkara',
    'tanggal_masuk_arsip' => 'tanggal_masuk_arsip'
];

if (!isset($allowed_sorts[$sort])) {
    $sort = 'id';
}

// Helper function to create sort URL
function sort_url($column) {
    global $sort, $dir, $q;
    $new_dir = ($sort === $column && $dir === 'ASC') ? 'DESC' : 'ASC';
    $params = ['sort' => $column, 'dir' => $new_dir];
    if ($q) $params['q'] = $q;
    return '?' . http_build_query($params);
}

// Helper function to get sort icon
function sort_icon($column) {
    global $sort, $dir;
    if ($sort !== $column) return '<i class="fa fa-sort text-muted"></i>';
    return $dir === 'ASC' ? '<i class="fa fa-sort-up text-white"></i>' : '<i class="fa fa-sort-down text-white"></i>';
}

echo "Testing Sorting Functionality\n";
echo "============================\n";
echo "Current sort: $sort\n";
echo "Current direction: $dir\n";
echo "Sort column: " . $allowed_sorts[$sort] . "\n\n";

echo "Testing sort URLs:\n";
echo "nomor_perkara: " . sort_url('nomor_perkara') . "\n";
echo "no_ruang: " . sort_url('no_ruang') . "\n";
echo "tanggal_masuk_arsip: " . sort_url('tanggal_masuk_arsip') . "\n\n";

echo "Testing sort icons:\n";
echo "nomor_perkara icon: " . strip_tags(sort_icon('nomor_perkara')) . "\n";
echo "no_ruang icon: " . strip_tags(sort_icon('no_ruang')) . "\n";

echo "\nSQL ORDER BY clause would be: ORDER BY " . $allowed_sorts[$sort] . " " . $dir . "\n";
?>
