<?php
// Simple test to see what columns exist
$config = [
    'host' => 'localhost',
    'username' => 'root',
    'password' => '',
    'database' => 'permohonan_salinan_putusan'
];

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "<h3>Users Sample Data:</h3>";
    $stmt = $pdo->query("SELECT * FROM users LIMIT 1");
    $user = $stmt->fetch();
    
    if ($user) {
        echo "<pre>";
        print_r(array_keys($user));
        echo "</pre>";
        
        echo "<p>Available columns in users table:</p>";
        echo "<ul>";
        foreach (array_keys($user) as $column) {
            if (!is_numeric($column)) {
                echo "<li>$column</li>";
            }
        }
        echo "</ul>";
    }
    
} catch (PDOException $e) {
    echo "ERROR: " . $e->getMessage();
}
?>
