<?php
// Test sederhana untuk memastikan aplikasi berjalan di XAMPP

echo "<h1>🚀 Test Aplikasi Permohonan Salinan Putusan</h1>";

// Test PHP Version
echo "<h2>📋 Informasi Sistem</h2>";
echo "<p><strong>PHP Version:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>Server:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "</p>";

// Test Database Connection
echo "<h2>🗄️ Test Koneksi Database</h2>";
try {
    $pdo = new PDO(
        "mysql:host=localhost;dbname=permohonan_salinan_putusan;charset=utf8mb4",
        "root",
        "",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "<p style='color: green;'>✅ <strong>Database Connected!</strong></p>";
    
    // Test query
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users");
    $result = $stmt->fetch();
    echo "<p>👥 Total users: " . $result['total'] . "</p>";
    
    // Show tables
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<p>📋 Tables: " . implode(", ", $tables) . "</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ <strong>Database Error:</strong> " . $e->getMessage() . "</p>";
}

echo "<h2>🔗 Link Aplikasi</h2>";
echo "<ul>";
echo "<li><a href='index.php'>🏠 Halaman Utama (Legacy)</a></li>";
echo "<li><a href='public/'>🚀 CodeIgniter 4 Public</a></li>";
echo "<li><a href='public/login.php'>🔐 Login</a></li>";
echo "<li><a href='public/register.php'>📝 Register</a></li>";
echo "</ul>";

echo "<h2>👤 Login Credentials</h2>";
echo "<p><strong>Admin:</strong><br>";
echo "Username: admin<br>";
echo "Password: password</p>";

echo "<hr>";
echo "<p><em>Test selesai pada " . date('Y-m-d H:i:s') . "</em></p>";
?>
