<?php
$config = [
    'host' => 'localhost',
    'username' => 'root',
    'password' => '',
    'database' => 'permohonan_salinan_putusan'
];

try {
    // First create database if not exists
    $pdo = new PDO(
        "mysql:host={$config['host']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    $pdo->exec("CREATE DATABASE IF NOT EXISTS {$config['database']}");
    echo "Database created/verified.\n";
    
    // Connect to the specific database
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    // Create users table
    $sql = "
    CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        email VARCHAR(100) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        nama_lengkap VARCHAR(100) NOT NULL,
        telepon VARCHAR(20),
        alamat TEXT,
        role ENUM('admin', 'pemohon') DEFAULT 'pemohon',
        is_verified BOOLEAN DEFAULT FALSE,
        verification_token VARCHAR(100),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "Users table created.\n";
    
    // Create permohonans table
    $sql = "
    CREATE TABLE IF NOT EXISTS permohonans (
        id INT AUTO_INCREMENT PRIMARY KEY,
        pemohon_id INT NOT NULL,
        kode_permohonan VARCHAR(20) UNIQUE NOT NULL,
        nomor_perkara VARCHAR(100) NOT NULL,
        tahun_perkara INT NOT NULL,
        para_pihak TEXT NOT NULL,
        jenis_perkara VARCHAR(50) NOT NULL,
        kebutuhan VARCHAR(100) NOT NULL,
        keterangan TEXT,
        status ENUM('pending', 'processing', 'completed', 'rejected') DEFAULT 'pending',
        rejection_reason TEXT,
        processed_by INT,
        processed_at TIMESTAMP NULL,
        completed_at TIMESTAMP NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (pemohon_id) REFERENCES users(id),
        FOREIGN KEY (processed_by) REFERENCES users(id)
    )";
    $pdo->exec($sql);
    echo "Permohonans table created.\n";
    
    // Create sample user if not exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE username = ?");
    $stmt->execute(['fahrultest']);
    
    if ($stmt->fetchColumn() == 0) {
        $stmt = $pdo->prepare("
            INSERT INTO users (username, email, password, nama_lengkap, telepon, alamat, role, is_verified) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([
            'fahrultest',
            'fahrul@test.com',
            password_hash('123456', PASSWORD_DEFAULT),
            'Fahrul Test User',
            '08123456789',
            'Jl. Test No. 123, Watampone',
            'pemohon',
            true
        ]);
        echo "Sample user created.\n";
    }
    
    // Get user ID
    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->execute(['fahrultest']);
    $user_id = $stmt->fetchColumn();
    
    // Create sample permohonan if not exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM permohonans WHERE pemohon_id = ?");
    $stmt->execute([$user_id]);
    
    if ($stmt->fetchColumn() == 0) {
        $stmt = $pdo->prepare("
            INSERT INTO permohonans (pemohon_id, kode_permohonan, nomor_perkara, tahun_perkara, para_pihak, jenis_perkara, kebutuhan, keterangan, status) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        // Sample data 1
        $stmt->execute([
            $user_id,
            'SP-2025-0001',
            '13/Pdt.G/2024/PN.Wtp',
            2024,
            'PT. ABC vs PT. XYZ',
            'Perdata',
            'Salinan Putusan',
            'Untuk keperluan banding',
            'completed'
        ]);
        
        // Sample data 2
        $stmt->execute([
            $user_id,
            'SP-2025-0002',
            '123/Pdt.G/2024/PN.Wtp',
            2024,
            'Ahmad bin Salam vs Siti binti Rahman',
            'Perdata',
            'Salinan Putusan',
            'Untuk keperluan eksekusi',
            'pending'
        ]);
        
        echo "Sample permohonans created.\n";
    }
    
    echo "Setup completed successfully!\n";
    echo "Test user: fahrultest / 123456\n";
    
} catch (PDOException $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
