<?php
// Check if user is logged in and is pemohon
if (!isLoggedIn() || getUserRole() !== 'pemohon') {
    redirect('?page=login');
}

// Get user's permohonans
$stmt = $pdo->prepare("
    SELECT p.*, 
           COUNT(pf.id) as jumlah_file,
           DATE_FORMAT(p.created_at, '%d/%m/%Y %H:%i') as tanggal_ajuan,
           DATE_FORMAT(p.processed_at, '%d/%m/%Y %H:%i') as tanggal_proses,
           DATE_FORMAT(p.completed_at, '%d/%m/%Y %H:%i') as tanggal_selesai
    FROM permohonans p 
    LEFT JOIN permohonan_files pf ON p.id = pf.permohonan_id 
    WHERE p.pemohon_id = ? 
    GROUP BY p.id 
    ORDER BY p.created_at DESC
");
$stmt->execute([$_SESSION['user_id']]);
$permohonans = $stmt->fetchAll();

// Get statistics
$totalPermohonan = count($permohonans);
$pending = array_filter($permohonans, fn($p) => $p['status'] === 'pending');
$diproses = array_filter($permohonans, fn($p) => $p['status'] === 'processing');
$selesai = array_filter($permohonans, fn($p) => $p['status'] === 'completed');
$ditolak = array_filter($permohonans, fn($p) => $p['status'] === 'rejected');

// Status labels and colors
$statusLabels = [
    'pending' => ['label' => 'Menunggu', 'color' => 'warning', 'icon' => 'clock'],
    'processing' => ['label' => 'Diproses', 'color' => 'info', 'icon' => 'cog'],
    'completed' => ['label' => 'Selesai', 'color' => 'success', 'icon' => 'check-circle'],
    'rejected' => ['label' => 'Ditolak', 'color' => 'danger', 'icon' => 'times-circle']
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permohonan Saya - PN Watampone</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .permohonan-card {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .permohonan-card:hover {
            border-color: #007bff;
            box-shadow: 0 5px 15px rgba(0,123,255,0.1);
        }
        .status-badge {
            font-size: 0.875rem;
            padding: 0.375rem 0.75rem;
            border-radius: 0.5rem;
        }
        .timeline {
            position: relative;
            padding-left: 30px;
        }
        .timeline::before {
            content: '';
            position: absolute;
            left: 15px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e9ecef;
        }
        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -19px;
            top: 8px;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #6c757d;
        }
        .timeline-item.active::before {
            background: #28a745;
        }
        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }
        .empty-state i {
            font-size: 4rem;
            color: #6c757d;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="setup.php">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="?page=dashboard">
                            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=permohonan-baru">
                            <i class="fas fa-plus-circle me-1"></i> Permohonan Baru
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="?page=permohonan-saya">
                            <i class="fas fa-list me-1"></i> Permohonan Saya
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?= htmlspecialchars($_SESSION['nama_lengkap']) ?>
                            <span class="badge bg-light text-dark ms-1">Pemohon</span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="?page=logout">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="py-4">
        <div class="container">
            <!-- Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h1 class="h3 mb-1 text-gray-800">
                                <i class="fas fa-list me-2 text-primary"></i>
                                Permohonan Saya
                            </h1>
                            <p class="text-muted mb-0">Daftar semua permohonan salinan putusan Anda</p>
                        </div>
                        <div class="text-end">
                            <a href="?page=permohonan-baru" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Permohonan Baru
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-primary h-100 py-2" style="border-left: 4px solid #007bff;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Permohonan
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= $totalPermohonan ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-warning h-100 py-2" style="border-left: 4px solid #ffc107;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        Menunggu
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= count($pending) ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-clock fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-info h-100 py-2" style="border-left: 4px solid #17a2b8;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        Diproses
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= count($diproses) ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-cog fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-success h-100 py-2" style="border-left: 4px solid #28a745;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Selesai
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= count($selesai) ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Permohonan List -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-custom">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-list me-2"></i>Daftar Permohonan
                            </h6>
                        </div>
                        <div class="card-body">
                            <?php if (empty($permohonans)): ?>
                                <div class="empty-state">
                                    <i class="fas fa-file-alt"></i>
                                    <h5 class="text-muted">Belum Ada Permohonan</h5>
                                    <p class="text-muted mb-3">Anda belum mengajukan permohonan salinan putusan</p>
                                    <a href="?page=permohonan-baru" class="btn btn-primary">
                                        <i class="fas fa-plus me-1"></i> Buat Permohonan Pertama
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="row">
                                    <?php foreach ($permohonans as $permohonan): ?>
                                        <div class="col-lg-6 col-xl-4 mb-4">
                                            <div class="permohonan-card p-4">
                                                <div class="d-flex align-items-start justify-content-between mb-3">
                                                    <div>
                                                        <h6 class="mb-1"><?= htmlspecialchars($permohonan['kode_permohonan']) ?></h6>
                                                        <small class="text-muted"><?= htmlspecialchars($permohonan['tanggal_ajuan']) ?></small>
                                                    </div>
                                                    <span class="badge bg-<?= $statusLabels[$permohonan['status']]['color'] ?> status-badge">
                                                        <i class="fas fa-<?= $statusLabels[$permohonan['status']]['icon'] ?> me-1"></i>
                                                        <?= $statusLabels[$permohonan['status']]['label'] ?>
                                                    </span>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <strong>Nomor Perkara:</strong><br>
                                                    <code><?= htmlspecialchars($permohonan['nomor_perkara']) ?></code>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <strong>Para Pihak:</strong><br>
                                                    <span class="text-truncate d-block" style="max-width: 100%;" title="<?= htmlspecialchars($permohonan['para_pihak']) ?>">
                                                        <?= htmlspecialchars($permohonan['para_pihak']) ?>
                                                    </span>
                                                </div>
                                                
                                                <div class="row mb-3">
                                                    <div class="col-6">
                                                        <small class="text-muted">Jenis Perkara:</small><br>
                                                        <strong><?= htmlspecialchars($permohonan['jenis_perkara']) ?></strong>
                                                    </div>
                                                    <div class="col-6">
                                                        <small class="text-muted">Kebutuhan:</small><br>
                                                        <strong><?= htmlspecialchars($permohonan['kebutuhan']) ?></strong>
                                                    </div>
                                                </div>
                                                
                                                <?php if ($permohonan['jumlah_file'] > 0): ?>
                                                <div class="mb-3">
                                                    <small class="text-muted">Dokumen:</small><br>
                                                    <span class="badge bg-info"><?= $permohonan['jumlah_file'] ?> file</span>
                                                </div>
                                                <?php endif; ?>
                                                
                                                <?php if ($permohonan['status'] === 'rejected' && $permohonan['rejection_reason']): ?>
                                                <div class="mb-3">
                                                    <small class="text-danger">Alasan Penolakan:</small><br>
                                                    <small class="text-danger"><?= htmlspecialchars($permohonan['rejection_reason']) ?></small>
                                                </div>
                                                <?php endif; ?>
                                                
                                                <div class="d-grid gap-2">
                                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewDetail('<?= $permohonan['id'] ?>')">
                                                        <i class="fas fa-eye me-1"></i>Lihat Detail
                                                    </button>
                                                    <a href="?page=print-permohonan&id=<?= $permohonan['id'] ?>" target="_blank" class="btn btn-outline-success btn-sm">
                                                        <i class="fas fa-print me-1"></i>Print
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Detail Modal -->
    <div class="modal fade" id="detailModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-file-alt me-2"></i>Detail Permohonan
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div id="detail-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewDetail(id) {
            const modal = new bootstrap.Modal(document.getElementById('detailModal'));
            modal.show();
            
            // Find permohonan data
            const permohonans = <?= json_encode($permohonans) ?>;
            const permohonan = permohonans.find(p => p.id == id);
            
            if (permohonan) {
                const statusLabels = <?= json_encode($statusLabels) ?>;
                const status = statusLabels[permohonan.status];
                
                let detailHtml = `
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Kode Permohonan:</strong><br>
                            <span class="text-primary">${permohonan.kode_permohonan}</span>
                        </div>
                        <div class="col-md-6">
                            <strong>Status:</strong><br>
                            <span class="badge bg-${status.color} status-badge">
                                <i class="fas fa-${status.icon} me-1"></i>${status.label}
                            </span>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <strong>Nomor Perkara:</strong><br>
                            <code>${permohonan.nomor_perkara}</code>
                        </div>
                        <div class="col-md-4">
                            <strong>Tahun:</strong><br>
                            ${permohonan.tahun_perkara}
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <strong>Para Pihak:</strong><br>
                        ${permohonan.para_pihak}
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Jenis Perkara:</strong><br>
                            ${permohonan.jenis_perkara}
                        </div>
                        <div class="col-md-6">
                            <strong>Kebutuhan:</strong><br>
                            ${permohonan.kebutuhan}
                        </div>
                    </div>
                `;
                
                if (permohonan.keterangan) {
                    detailHtml += `
                        <div class="mb-3">
                            <strong>Keterangan:</strong><br>
                            ${permohonan.keterangan}
                        </div>
                    `;
                }
                
                if (permohonan.jumlah_file > 0) {
                    detailHtml += `
                        <div class="mb-3">
                            <strong>Dokumen Pendukung:</strong><br>
                            <span class="badge bg-info">${permohonan.jumlah_file} file terupload</span>
                        </div>
                    `;
                }
                
                if (permohonan.rejection_reason) {
                    detailHtml += `
                        <div class="mb-3">
                            <strong>Alasan Penolakan:</strong><br>
                            <div class="alert alert-danger">
                                ${permohonan.rejection_reason}
                            </div>
                        </div>
                    `;
                }
                
                // Timeline
                detailHtml += `
                    <div class="mb-3">
                        <strong>Timeline Proses:</strong>
                        <div class="timeline mt-3">
                            <div class="timeline-item active">
                                <strong>Permohonan Diajukan</strong><br>
                                <small class="text-muted">${permohonan.tanggal_ajuan}</small>
                            </div>
                `;
                
                if (permohonan.processed_at) {
                    detailHtml += `
                            <div class="timeline-item active">
                                <strong>Mulai Diproses</strong><br>
                                <small class="text-muted">${permohonan.tanggal_proses}</small>
                            </div>
                    `;
                }
                
                if (permohonan.completed_at) {
                    detailHtml += `
                            <div class="timeline-item active">
                                <strong>Selesai</strong><br>
                                <small class="text-muted">${permohonan.tanggal_selesai}</small>
                            </div>
                    `;
                }
                
                detailHtml += `
                        </div>
                    </div>
                `;
                
                document.getElementById('detail-content').innerHTML = detailHtml;
            }
        }
    </script>
</body>
</html>
