<?php
// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_field = $_POST['login_field'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($login_field) || empty($password)) {
        setFlashMessage('error', 'Username/Email/No. Telepon dan password harus diisi');
    } else {
        // Check user in database - support username, email, or phone number
        $stmt = $pdo->prepare("
            SELECT u.*, p.nama_lengkap, p.status_verified, p.no_telepon
            FROM users u 
            LEFT JOIN pemohon_profiles p ON p.user_id = u.id 
            WHERE (u.username = ? OR u.email = ? OR p.no_telepon = ?) AND u.is_active = 1
            LIMIT 1
        ");
        $stmt->execute([$login_field, $login_field, $login_field]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            // For pemohon, check if verified
            if ($user['role'] === 'pemohon' && $user['status_verified'] !== 'verified') {
                setFlashMessage('error', 'Akun Anda belum diverifikasi oleh petugas');
            } else {
                // Set session
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['email'] = $user['email'];
                $_SESSION['role'] = $user['role'];
                $_SESSION['nama_lengkap'] = $user['nama_lengkap'] ?? $user['username'];
                
                setFlashMessage('success', 'Login berhasil!');
                redirect('?page=dashboard');
            }
        } else {
            setFlashMessage('error', 'Username/Email/No. Telepon atau password salah');
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Permohonan Salinan Putusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
            background: rgba(255,255,255,0.95);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card card-custom">
                    <div class="card-body p-5">
                        <!-- Header -->
                        <div class="text-center mb-4">
                            <div class="mb-3">
                                <i class="fas fa-gavel fa-3x text-primary"></i>
                            </div>
                            <h3 class="card-title fw-bold text-primary">Login</h3>
                            <p class="text-muted">Sistem Permohonan Salinan Putusan<br>Pengadilan Negeri Watampone</p>
                        </div>

                        <!-- Flash Messages -->
                        <?php if ($error = getFlashMessage('error')): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-circle me-2"></i>
                                <?= htmlspecialchars($error) ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($success = getFlashMessage('success')): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                <?= htmlspecialchars($success) ?>
                            </div>
                        <?php endif; ?>

                        <!-- Login Form -->
                        <form method="POST">
                            <div class="mb-3">
                                <label for="login_field" class="form-label">
                                    <i class="fas fa-user me-1"></i> Username / Email / No. Telepon
                                </label>
                                <input type="text" 
                                       class="form-control" 
                                       id="login_field" 
                                       name="login_field" 
                                       placeholder="Masukkan username, email, atau nomor telepon"
                                       required>
                                <div class="form-text">
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Anda bisa login menggunakan username, email, atau nomor telepon
                                    </small>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">
                                    <i class="fas fa-lock me-1"></i> Password
                                </label>
                                <div class="input-group">
                                    <input type="password" 
                                           class="form-control" 
                                           id="password" 
                                           name="password" 
                                           placeholder="Masukkan password Anda"
                                           required>
                                    <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                        <i class="fas fa-eye" id="eyeIcon"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i> Login
                                </button>
                            </div>
                        </form>

                        <!-- Divider -->
                        <hr class="my-4">

                        <!-- Register Link -->
                        <div class="text-center">
                            <p class="mb-2">Belum memiliki akun?</p>
                            <a href="?page=register" class="btn btn-outline-primary">
                                <i class="fas fa-user-plus me-2"></i> Daftar Sebagai Pemohon
                            </a>
                        </div>

                        <!-- Demo Accounts Info -->
                        <div class="mt-4">
                            <div class="alert alert-info">
                                <h6><i class="fas fa-info-circle me-2"></i>Akun Demo (Bisa login dengan username/email/telepon):</h6>
                                <small>
                                    <strong>Admin:</strong> admin atau admin@pn-watampone.go.id / password<br>
                                    <strong>Petugas:</strong> petugas1 atau petugas1@pn-watampone.go.id / password<br>
                                    <strong>Pemohon:</strong> pemohon_demo atau pemohon@example.com / password
                                </small>
                                <hr class="my-2">
                                <small class="text-muted">
                                    <i class="fas fa-lightbulb me-1"></i>
                                    <strong>Tips:</strong> Untuk pemohon yang sudah registrasi dan memiliki nomor telepon, 
                                    Anda juga bisa login menggunakan nomor telepon tersebut.
                                </small>
                            </div>
                        </div>

                        <!-- Back to Home -->
                        <div class="text-center mt-3">
                            <a href="setup.php" class="text-decoration-none">
                                <i class="fas fa-arrow-left me-1"></i> Kembali ke Beranda
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle password visibility
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordField = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            } else {
                passwordField.type = 'password';
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            }
        });
    </script>
</body>
</html>
