<?php
// Check if user is admin or petugas
if (!isLoggedIn() || !in_array(getUserRole(), ['admin', 'petugas'])) {
    redirect('?page=dashboard');
}

$action = $_GET['action'] ?? '';
$userId = $_GET['user_id'] ?? '';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'update_status' && $userId) {
        $newStatus = $_POST['status'];
        $stmt = $pdo->prepare("UPDATE users SET is_active = ? WHERE id = ?");
        if ($stmt->execute([$newStatus, $userId])) {
            $success = "Status user berhasil diperbarui";
        } else {
            $error = "Gagal memperbarui status user";
        }
    }
    
    if ($action === 'update_role' && $userId) {
        $newRole = $_POST['role'];
        $stmt = $pdo->prepare("UPDATE users SET role = ? WHERE id = ?");
        if ($stmt->execute([$newRole, $userId])) {
            $success = "Role user berhasil diperbarui";
        } else {
            $error = "Gagal memperbarui role user";
        }
    }
    
    if ($action === 'verify_profile' && $userId) {
        $status = $_POST['verify_status'];
        $stmt = $pdo->prepare("UPDATE pemohon_profiles SET status_verified = ? WHERE user_id = ?");
        if ($stmt->execute([$status, $userId])) {
            $success = "Status verifikasi berhasil diperbarui";
        } else {
            $error = "Gagal memperbarui status verifikasi";
        }
    }
}

// Get all users with their profiles
$sql = "SELECT u.id, u.nama_lengkap, u.username, u.email, u.role, u.nomor_hp, u.is_active, u.created_at,
               p.nik, p.alamat, p.status_verified, p.tempat_lahir, p.tanggal_lahir
        FROM users u 
        LEFT JOIN pemohon_profiles p ON p.user_id = u.id 
        ORDER BY u.created_at DESC";

$stmt = $pdo->query($sql);
$users = $stmt->fetchAll();

// Get statistics
$statsStmt = $pdo->query("SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN role = 'admin' THEN 1 ELSE 0 END) as admin,
    SUM(CASE WHEN role = 'petugas' THEN 1 ELSE 0 END) as petugas,
    SUM(CASE WHEN role = 'pemohon' THEN 1 ELSE 0 END) as pemohon,
    SUM(CASE WHEN is_active = 1 THEN 1 ELSE 0 END) as active,
    SUM(CASE WHEN is_active = 0 THEN 1 ELSE 0 END) as inactive
    FROM users
");
$stats = $statsStmt->fetch();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola User - PN Watampone</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .bg-primary-custom { background-color: #1f4e79 !important; }
        .card-stats { border-left: 4px solid #1f4e79; }
        .table th { background-color: #f8f9fa; }
        .badge-role { font-size: 0.8em; }
        .status-active { color: #28a745; }
        .status-inactive { color: #dc3545; }
        .status-pending { color: #ffc107; }
        .status-verified { color: #28a745; }
        .status-rejected { color: #dc3545; }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>
    
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="?page=dashboard">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
        </div>
    </nav>

    <div class="container mt-4">
        <?php if (isset($success)): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i><?= $success ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i><?= $error ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
        <?php endif; ?>

        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2><i class="fas fa-users me-2"></i>Kelola User</h2>
                <p class="text-muted">Manajemen akun pengguna dan verifikasi</p>
            </div>
            <a href="?page=dashboard" class="btn btn-outline-primary">
                <i class="fas fa-arrow-left me-1"></i> Kembali
            </a>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-primary"><?= $stats['total'] ?></h3>
                        <p class="mb-0">Total User</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-success"><?= $stats['admin'] ?></h3>
                        <p class="mb-0">Admin</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-info"><?= $stats['petugas'] ?></h3>
                        <p class="mb-0">Petugas</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-warning"><?= $stats['pemohon'] ?></h3>
                        <p class="mb-0">Pemohon</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-success"><?= $stats['active'] ?></h3>
                        <p class="mb-0">Aktif</p>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="card card-stats">
                    <div class="card-body text-center">
                        <h3 class="text-danger"><?= $stats['inactive'] ?></h3>
                        <p class="mb-0">Nonaktif</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>Daftar User
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Nama Lengkap</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Verifikasi</th>
                                <th>Terdaftar</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?= $user['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($user['nama_lengkap']) ?></strong>
                                    <?php if ($user['nik']): ?>
                                    <br><small class="text-muted">NIK: <?= htmlspecialchars($user['nik']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($user['username']) ?></td>
                                <td><?= htmlspecialchars($user['email']) ?></td>
                                <td>
                                    <span class="badge badge-role <?= 
                                        $user['role'] === 'admin' ? 'bg-success' : 
                                        ($user['role'] === 'petugas' ? 'bg-info' : 'bg-warning') 
                                    ?>">
                                        <?= ucfirst($user['role']) ?>
                                    </span>
                                </td>
                                <td>
                                    <i class="fas fa-circle <?= $user['is_active'] ? 'status-active' : 'status-inactive' ?>"></i>
                                    <?= $user['is_active'] ? 'Aktif' : 'Nonaktif' ?>
                                </td>
                                <td>
                                    <?php if ($user['status_verified']): ?>
                                    <i class="fas fa-circle <?= 
                                        $user['status_verified'] === 'verified' ? 'status-verified' : 
                                        ($user['status_verified'] === 'pending' ? 'status-pending' : 'status-rejected') 
                                    ?>"></i>
                                    <?= ucfirst($user['status_verified']) ?>
                                    <?php else: ?>
                                    <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d/m/Y', strtotime($user['created_at'])) ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button class="btn btn-outline-primary" onclick="showUserDetail(<?= $user['id'] ?>)">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <?php if (getUserRole() === 'admin'): ?>
                                        <button class="btn btn-outline-warning" onclick="editUser(<?= $user['id'] ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- User Detail Modal -->
    <div class="modal fade" id="userDetailModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detail User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="userDetailContent">
                    <!-- Content will be loaded here -->
                </div>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div class="modal fade" id="editUserModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit User</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="?page=user-ajax" id="editUserForm">
                    <div class="modal-body" id="editUserContent">
                        <!-- Content will be loaded here -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function showUserDetail(userId) {
            // Load user detail via AJAX
            fetch('user-ajax.php?action=detail&user_id=' + userId)
                .then(response => response.text())
                .then(html => {
                    document.getElementById('userDetailContent').innerHTML = html;
                    new bootstrap.Modal(document.getElementById('userDetailModal')).show();
                });
        }

        function editUser(userId) {
            // Load edit form via AJAX
            fetch('user-ajax.php?action=edit&user_id=' + userId)
                .then(response => response.text())
                .then(html => {
                    document.getElementById('editUserContent').innerHTML = html;
                    new bootstrap.Modal(document.getElementById('editUserModal')).show();
                });
        }
    </script>
</body>
</html>
