<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permohonan Salinan Putusan - PN Watampone</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(135deg, #2563eb, #1e40af);
            color: white;
            padding: 80px 0;
        }
        .feature-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            padding: 1.5rem;
        }
        .feature-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }
        .btn-custom {
            border-radius: 8px;
            padding: 12px 24px;
            font-weight: 500;
        }
        .section-padding {
            padding: 60px 0;
        }
        .text-primary-custom {
            color: #2563eb !important;
        }
        .bg-light-custom {
            background-color: #f8fafc !important;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark" style="background: #1e40af;">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="#">
                <img src="<?php echo getImageUrl('Logo_pnwtp.png'); ?>?v=<?php echo time(); ?>" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if (isLoggedIn()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="?page=dashboard">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?page=logout">Logout</a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="?page=login">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="?page=register">Daftar</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container text-center hero-content">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <img src="<?php echo getImageUrl('Logo_pnwtp.png'); ?>?v=<?php echo time(); ?>" alt="PN Watampone" height="60" class="mb-4">
                    <h1 class="display-5 fw-bold mb-3">Permohonan Salinan Putusan</h1>
                    <p class="lead mb-4">Sistem Online Pengadilan Negeri Watampone</p>
                    
                    <?php if (isLoggedIn()): ?>
                        <a href="?page=dashboard" class="btn btn-light btn-custom">
                            Dashboard
                        </a>
                    <?php else: ?>
                        <a href="?page=login" class="btn btn-light btn-custom me-3">
                            Login
                        </a>
                        <a href="?page=register" class="btn btn-outline-light btn-custom">
                            Daftar Sebagai Pemohon
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-12">
                    <h2 class="fw-bold">Fitur Aplikasi</h2>
                    <p class="text-muted">Layanan digital untuk memudahkan proses permohonan salinan putusan</p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center p-5">
                            <div class="mb-4">
                                <i class="fas fa-user-plus fa-3x text-primary"></i>
                            </div>
                            <h5 class="card-title">Registrasi Online</h5>
                            <p class="card-text">Daftar akun dengan mudah menggunakan data KTP dan email</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center p-5">
                            <div class="mb-4">
                                <i class="fas fa-file-upload fa-3x text-success"></i>
                            </div>
                            <h5 class="card-title">Upload Dokumen</h5>
                            <p class="card-text">Upload KTP dan dokumen pendukung dengan format yang aman</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="card feature-card h-100">
                        <div class="card-body text-center p-5">
                            <div class="mb-4">
                                <i class="fas fa-file-pdf fa-3x text-danger"></i>
                            </div>
                            <h5 class="card-title">Generate PDF</h5>
                            <p class="card-text">Otomatis membuat PDF permohonan sesuai format resmi</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Statistics Section -->
    <section class="bg-light py-5">
        <div class="container">
            <div class="row text-center">
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 bg-transparent">
                        <div class="card-body">
                            <h3 class="text-primary fw-bold">3</h3>
                            <p class="text-muted">Role Pengguna</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 bg-transparent">
                        <div class="card-body">
                            <h3 class="text-success fw-bold">24/7</h3>
                            <p class="text-muted">Akses Online</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 bg-transparent">
                        <div class="card-body">
                            <h3 class="text-info fw-bold">5</h3>
                            <p class="text-muted">Status Permohonan</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="card border-0 bg-transparent">
                        <div class="card-body">
                            <h3 class="text-warning fw-bold">100%</h3>
                            <p class="text-muted">Digital Process</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About PN Watampone Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="text-center">
                        <img src="<?php echo getImageUrl('gedung-pn-wtp.png'); ?>?v=<?php echo time(); ?>" alt="Gedung PN Watampone" class="img-fluid rounded shadow" style="max-height: 400px;" onload="console.log('Building image loaded')" onerror="console.error('Building image failed')">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ps-lg-4">
                        <h2 class="fw-bold mb-4">
                            <img src="<?php echo getImageUrl('Logo_pnwtp.png'); ?>?v=<?php echo time(); ?>" alt="Logo" height="50" class="me-3" onload="console.log('About logo loaded')" onerror="console.error('About logo failed')">
                            Pengadilan Negeri Watampone
                        </h2>
                        <p class="text-muted mb-4">
                            Pengadilan Negeri Watampone merupakan salah satu pengadilan tingkat pertama yang berada di wilayah 
                            Kabupaten Bone, Sulawesi Selatan. Kami berkomitmen memberikan pelayanan hukum yang adil, transparan, 
                            dan mudah diakses oleh masyarakat.
                        </p>
                        
                        <div class="row mb-4">
                            <div class="col-6">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-map-marker-alt text-primary me-3"></i>
                                    <div>
                                        <strong>Alamat</strong><br>
                                        <small class="text-muted">Watampone, Kab. Bone</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-clock text-primary me-3"></i>
                                    <div>
                                        <strong>Jam Layanan</strong><br>
                                        <small class="text-muted">08:00 - 16:00 WITA</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-6">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-phone text-primary me-3"></i>
                                    <div>
                                        <strong>Telepon</strong><br>
                                        <small class="text-muted">(0481) 21XXX</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="d-flex align-items-center mb-3">
                                    <i class="fas fa-envelope text-primary me-3"></i>
                                    <div>
                                        <strong>Email</strong><br>
                                        <small class="text-muted">pn.watampone@go.id</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Info Section -->
    <section class="py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h3 class="fw-bold mb-4">Alur Permohonan Salinan Putusan</h3>
                    <div class="d-flex mb-3">
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                <strong>1</strong>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6>Registrasi & Verifikasi</h6>
                            <p class="text-muted">Daftar akun dan tunggu verifikasi dari petugas</p>
                        </div>
                    </div>
                    <div class="d-flex mb-3">
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                <strong>2</strong>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6>Ajukan Permohonan</h6>
                            <p class="text-muted">Isi form dan upload dokumen pendukung</p>
                        </div>
                    </div>
                    <div class="d-flex mb-3">
                        <div class="flex-shrink-0">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                <strong>3</strong>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6>Proses & Persetujuan</h6>
                            <p class="text-muted">Petugas memproses permohonan Anda</p>
                        </div>
                    </div>
                    <div class="d-flex mb-3">
                        <div class="flex-shrink-0">
                            <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                <strong>4</strong>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6>Download & Cetak</h6>
                            <p class="text-muted">Download PDF permohonan yang sudah disetujui</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <i class="fas fa-clipboard-list" style="font-size: 200px; color: #e9ecef;"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer style="background: linear-gradient(135deg, #1e3a8a, #3b82f6); color: white;" class="py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h6><i class="fas fa-gavel me-2"></i>Pengadilan Negeri Watampone</h6>
                    <p class="mb-0">Sistem Permohonan Salinan Putusan Online</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; <?= date('Y') ?> PN Watampone. All rights reserved.</p>
                    <small>Compatible with PHP <?= PHP_VERSION ?></small>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="fix-images.js"></script>
</body>
</html>
