<?php
// Check if user is logged in and is admin
if (!isLoggedIn() || getUserRole() !== 'admin') {
    redirect('?page=login');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Galeri Gambar - PN Watampone</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .image-card {
            transition: transform 0.3s ease;
        }
        .image-card:hover {
            transform: translateY(-5px);
        }
        .image-preview {
            height: 200px;
            object-fit: contain;
            width: 100%;
            background: #f8f9fa;
            border-radius: 10px;
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="setup.php">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="?page=dashboard">
                            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="?page=galeri">
                            <i class="fas fa-images me-1"></i> Galeri Gambar
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?= htmlspecialchars($_SESSION['nama_lengkap']) ?>
                            <span class="badge bg-light text-dark ms-1">Admin</span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="?page=logout">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="py-4">
        <div class="container">
            <!-- Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <h1 class="h3 mb-1 text-gray-800">
                                <i class="fas fa-images me-2 text-primary"></i>
                                Galeri Gambar
                            </h1>
                            <p class="text-muted mb-0">Koleksi gambar resmi Pengadilan Negeri Watampone</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Image Gallery -->
            <div class="row">
                <!-- Logo PN Watampone -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card card-custom image-card h-100">
                        <div class="card-body text-center">
                            <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="Logo PN Watampone" class="image-preview mb-3">
                            <h5 class="card-title">
                                <i class="fas fa-certificate text-warning me-2"></i>
                                Logo PN Watampone
                            </h5>
                            <p class="card-text text-muted">
                                Logo resmi Pengadilan Negeri Watampone digunakan di navbar dan header aplikasi.
                            </p>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-primary btn-sm" onclick="viewImage('/permohonan-salinan-putusan/gambar/Logo_pnwtp.png', 'Logo PN Watampone')">
                                    <i class="fas fa-eye me-1"></i> Lihat Detail
                                </button>
                                <small class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Digunakan di: Navbar, Hero Section, Official Documents
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Gedung PN Watampone -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card card-custom image-card h-100">
                        <div class="card-body text-center">
                            <img src="/permohonan-salinan-putusan/gambar/gedung-pn-wtp.png" alt="Gedung PN Watampone" class="image-preview mb-3">
                            <h5 class="card-title">
                                <i class="fas fa-building text-info me-2"></i>
                                Gedung PN Watampone
                            </h5>
                            <p class="card-text text-muted">
                                Foto gedung Pengadilan Negeri Watampone digunakan sebagai background hero section.
                            </p>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-primary btn-sm" onclick="viewImage('/permohonan-salinan-putusan/gambar/gedung-pn-wtp.png', 'Gedung PN Watampone')">
                                    <i class="fas fa-eye me-1"></i> Lihat Detail
                                </button>
                                <small class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Digunakan di: Hero Background, About Section
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Kop Surat -->
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card card-custom image-card h-100">
                        <div class="card-body text-center">
                            <img src="/permohonan-salinan-putusan/gambar/kop_surat.png" alt="Kop Surat PN Watampone" class="image-preview mb-3">
                            <h5 class="card-title">
                                <i class="fas fa-file-contract text-success me-2"></i>
                                Kop Surat Resmi
                            </h5>
                            <p class="card-text text-muted">
                                Kop surat resmi Pengadilan Negeri Watampone untuk dokumen permohonan dan surat resmi.
                            </p>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-primary btn-sm" onclick="viewImage('/permohonan-salinan-putusan/gambar/kop_surat.png', 'Kop Surat Resmi')">
                                    <i class="fas fa-eye me-1"></i> Lihat Detail
                                </button>
                                <small class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Digunakan di: Detail Permohonan, Dokumen Print
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Usage Information -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="card card-custom">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-info-circle me-2"></i>
                                Informasi Penggunaan Gambar
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="fw-bold">📍 Lokasi File:</h6>
                                    <ul class="list-unstyled">
                                        <li><code>/gambar/Logo_pnwtp.png</code></li>
                                        <li><code>/gambar/gedung-pn-wtp.png</code></li>
                                        <li><code>/gambar/kop_surat.png</code></li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="fw-bold">🎯 Implementasi:</h6>
                                    <ul class="list-unstyled">
                                        <li>✅ Navbar di semua halaman</li>
                                        <li>✅ Hero section homepage</li>
                                        <li>✅ About section</li>
                                        <li>✅ Dokumen permohonan resmi</li>
                                        <li>✅ Print layout</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Image Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="imageModalTitle">Detail Gambar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <img id="modalImage" src="" alt="" class="img-fluid" style="max-height: 500px;">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewImage(src, title) {
            document.getElementById('modalImage').src = src;
            document.getElementById('imageModalTitle').textContent = title;
            new bootstrap.Modal(document.getElementById('imageModal')).show();
        }
    </script>
</body>
</html>
