<?php
// Check PHP version and show appropriate message
if (version_compare(PHP_VERSION, '8.1.0', '<')) {
    echo "<div style='padding: 20px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; margin: 20px; font-family: Arial, sans-serif;'>";
    echo "<h2 style='color: #dc3545; margin-bottom: 15px;'>⚠️ PHP Version Compatibility Issue</h2>";
    echo "<p><strong>Current PHP Version:</strong> " . PHP_VERSION . "</p>";
    echo "<p><strong>Required PHP Version:</strong> 8.1.0 or higher</p>";
    echo "<hr style='margin: 20px 0;'>";
    echo "<h3 style='color: #007bff;'>🔧 Solutions:</h3>";
    echo "<ol>";
    echo "<li><strong>Update XAMPP:</strong> Download XAMPP with PHP 8.1+ from <a href='https://www.apachefriends.org/download.html' target='_blank'>apachefriends.org</a></li>";
    echo "<li><strong>Use Alternative Framework:</strong> We can create a custom PHP application that works with PHP 8.0</li>";
    echo "<li><strong>Use Different Environment:</strong> Use WAMP, Laragon, or Docker with PHP 8.1+</li>";
    echo "</ol>";
    echo "<hr style='margin: 20px 0;'>";
    echo "<h3 style='color: #28a745;'>🚀 Alternative: Custom PHP Application</h3>";
    echo "<p>Click the button below to create a custom PHP application that works with your current PHP version:</p>";
    echo "<a href='setup.php' style='display: inline-block; padding: 12px 24px; background: #007bff; color: white; text-decoration: none; border-radius: 6px; font-weight: bold;'>Create Custom Application</a>";
    echo "</div>";
    exit;
}

// If PHP version is OK, redirect to CodeIgniter
header('Location: index.php');
exit;
?>
