<?php
echo "<h1>🔍 PHP Version Information</h1>";
echo "<hr>";

// PHP Version
echo "<h2>📊 PHP Version</h2>";
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";
echo "<p><strong>PHP SAPI:</strong> " . php_sapi_name() . "</p>";
echo "<p><strong>Server Software:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "</p>";

// Extensions
echo "<h2>🔧 Important Extensions</h2>";
$extensions = ['pdo', 'pdo_mysql', 'mysqli', 'mbstring', 'openssl', 'json', 'session'];

echo "<table class='table table-striped' style='border: 1px solid #ddd; border-collapse: collapse; width: 100%;'>";
echo "<tr style='background: #f5f5f5;'><th style='border: 1px solid #ddd; padding: 8px;'>Extension</th><th style='border: 1px solid #ddd; padding: 8px;'>Status</th></tr>";

foreach ($extensions as $ext) {
    $status = extension_loaded($ext) ? "✅ Loaded" : "❌ Not Loaded";
    $color = extension_loaded($ext) ? "green" : "red";
    echo "<tr><td style='border: 1px solid #ddd; padding: 8px;'>$ext</td><td style='border: 1px solid #ddd; padding: 8px; color: $color;'>$status</td></tr>";
}
echo "</table>";

// Configuration
echo "<h2>⚙️ PHP Configuration</h2>";
echo "<table style='border: 1px solid #ddd; border-collapse: collapse; width: 100%;'>";
echo "<tr style='background: #f5f5f5;'><th style='border: 1px solid #ddd; padding: 8px;'>Setting</th><th style='border: 1px solid #ddd; padding: 8px;'>Value</th></tr>";

$configs = [
    'memory_limit' => ini_get('memory_limit'),
    'upload_max_filesize' => ini_get('upload_max_filesize'),
    'post_max_size' => ini_get('post_max_size'),
    'max_execution_time' => ini_get('max_execution_time'),
    'error_reporting' => ini_get('error_reporting'),
    'display_errors' => ini_get('display_errors') ? 'On' : 'Off'
];

foreach ($configs as $key => $value) {
    echo "<tr><td style='border: 1px solid #ddd; padding: 8px;'>$key</td><td style='border: 1px solid #ddd; padding: 8px;'>$value</td></tr>";
}
echo "</table>";

// Database test
echo "<h2>🗄️ Database Test</h2>";
try {
    // Test local XAMPP connection
    $pdo_local = new PDO('mysql:host=localhost;dbname=information_schema', 'root', '');
    echo "<p>✅ <strong>Local MySQL Connection:</strong> SUCCESS</p>";
    echo "<p>📊 <strong>MySQL Version:</strong> " . $pdo_local->query('SELECT VERSION()')->fetchColumn() . "</p>";
} catch (Exception $e) {
    echo "<p>❌ <strong>Local MySQL Connection:</strong> FAILED - " . $e->getMessage() . "</p>";
}

// XAMPP specific info
echo "<h2>📁 XAMPP Information</h2>";
echo "<p><strong>Document Root:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p><strong>Script Path:</strong> " . __FILE__ . "</p>";
echo "<p><strong>Current Working Directory:</strong> " . getcwd() . "</p>";

// PHP.ini location
echo "<h2>📋 PHP Configuration File</h2>";
echo "<p><strong>Loaded php.ini:</strong> " . php_ini_loaded_file() . "</p>";

$scanned = php_ini_scanned_files();
if ($scanned) {
    echo "<p><strong>Additional .ini files:</strong><br>" . nl2br($scanned) . "</p>";
}

echo "<hr>";
echo "<p><small>Generated on: " . date('Y-m-d H:i:s') . "</small></p>";
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; }
table { margin: 10px 0; }
th { font-weight: bold; }
</style>
