<?php
require_once 'config.php';

if ($_POST) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    try {
        $pdo = getDbConnection();
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND is_active = 1");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['isLoggedIn'] = true;
            
            echo "<div style='color: green; padding: 10px; background: #e8f5e8; border: 1px solid #4caf50; margin: 10px 0;'>";
            echo "✅ Login berhasil! Selamat datang, " . htmlspecialchars($user['username']) . "!<br>";
            echo "Role: " . htmlspecialchars($user['role']) . "<br>";
            echo "<a href='public/dashboard.php'>Go to Dashboard</a>";
            echo "</div>";
        } else {
            echo "<div style='color: red; padding: 10px; background: #ffe8e8; border: 1px solid #f44336; margin: 10px 0;'>";
            echo "❌ Username atau password salah!";
            echo "</div>";
        }
    } catch (Exception $e) {
        echo "<div style='color: red; padding: 10px; background: #ffe8e8; border: 1px solid #f44336; margin: 10px 0;'>";
        echo "❌ Error: " . $e->getMessage();
        echo "</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistem Permohonan Salinan Putusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header text-center">
                        <h3>🔐 Login Sistem</h3>
                        <p class="mb-0">Permohonan Salinan Putusan PN Watampone</p>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">Login</button>
                        </form>
                        
                        <hr>
                        
                        <div class="alert alert-info">
                            <strong>🔑 Default Credentials:</strong><br>
                            Username: <code>admin</code><br>
                            Password: <code>password</code>
                        </div>
                        
                        <div class="text-center mt-3">
                            <small>
                                <a href="public/">CodeIgniter 4 Version</a> | 
                                <a href="test.php">Test Database</a> |
                                <a href="setup_quick.php">Setup Database</a>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
