<?php
/**
 * Front Controller - Entry Point for Permohonan Salinan Putusan
 * Pengadilan Negeri Watampone
 * 
 * This file serves as the main entry point and routes requests appropriately
 */

// Check if we're accessing from the correct path
$requestUri = $_SERVER['REQUEST_URI'] ?? '';
$scriptName = $_SERVER['SCRIPT_NAME'] ?? '';

// Get the base path
$basePath = dirname($scriptName);
if ($basePath === '/') {
    $basePath = '';
}

// Check if this is a direct access to index.php
if (basename($_SERVER['PHP_SELF']) === 'index.php') {
    // Forward all query parameters
    $queryString = $_SERVER['QUERY_STRING'] ?? '';
    $redirectUrl = 'public/setup.php';
    
    if (!empty($queryString)) {
        $redirectUrl .= '?' . $queryString;
    }
    
    header("Location: $redirectUrl");
    exit;
}

// If somehow we get here, just include the main application
require_once 'public/setup.php';
?>
