-- Perbaikan Schema: Mengubah nama kolom nama_file menjadi file_name
-- untuk mencocokkan dengan kode aplikasi

-- 1. Hapus tabel permohonan_files jika ada (karena foreign key)
DROP TABLE IF EXISTS `permohonan_files`;

-- 2. Buat ulang tabel permohonan_files dengan nama kolom yang benar
CREATE TABLE IF NOT EXISTS `permohonan_files` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `permohonan_id` INT NOT NULL,
    `file_name` VARCHAR(255) NOT NULL,
    `nama_asli` VARCHAR(255) NOT NULL,
    `file_path` VARCHAR(500) NOT NULL,
    `file_type` VARCHAR(100) NOT NULL,
    `file_size` INT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`permohonan_id`) REFERENCES `permohonans`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 3. Pastikan semua kolom yang diperlukan ada di tabel users
ALTER TABLE `users` 
ADD COLUMN IF NOT EXISTS `ktp_path` VARCHAR(500) NULL,
ADD COLUMN IF NOT EXISTS `role` ENUM('admin', 'user') DEFAULT 'user';

-- 4. Pastikan semua kolom yang diperlukan ada di tabel permohonans
ALTER TABLE `permohonans` 
ADD COLUMN IF NOT EXISTS `processed_at` TIMESTAMP NULL,
ADD COLUMN IF NOT EXISTS `keterangan` TEXT NULL;
