-- Database creation script for Permohonan Salinan Putusan
-- Run this script in phpMyAdmin or MySQL command line

-- Create database
CREATE DATABASE IF NOT EXISTS `permohonan_salinan_putusan` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

USE `permohonan_salinan_putusan`;

-- Table: users
CREATE TABLE `users` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','petugas','pemohon') NOT NULL DEFAULT 'pemohon',
  `is_active` tinyint(1) NOT NULL DEFAULT 0,
  `email_verified_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `idx_email` (`email`),
  KEY `idx_username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: pemohon_profiles
CREATE TABLE `pemohon_profiles` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL,
  `nama_lengkap` varchar(255) NOT NULL,
  `nik` varchar(16) NOT NULL,
  `no_telepon` varchar(15) NOT NULL,
  `alamat` text NOT NULL,
  `ktp_path` varchar(255) DEFAULT NULL,
  `status_verified` enum('pending','verified','rejected') NOT NULL DEFAULT 'pending',
  `verified_by` int(11) UNSIGNED DEFAULT NULL,
  `verified_at` datetime DEFAULT NULL,
  `rejection_reason` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nik` (`nik`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status_verified` (`status_verified`),
  CONSTRAINT `fk_pemohon_profiles_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_pemohon_profiles_verified_by` FOREIGN KEY (`verified_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: permohonans
CREATE TABLE `permohonans` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL,
  `nomor_perkara` varchar(100) NOT NULL,
  `nama_terdakwa` varchar(255) NOT NULL,
  `tujuan_permohonan` text NOT NULL,
  `status` enum('pending','diterima','diproses','selesai','ditolak') NOT NULL DEFAULT 'pending',
  `catatan_internal` text DEFAULT NULL,
  `catatan_pemohon` text DEFAULT NULL,
  `processed_by` int(11) UNSIGNED DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL,
  `pdf_generated_path` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_nomor_perkara` (`nomor_perkara`),
  KEY `idx_status` (`status`),
  CONSTRAINT `fk_permohonans_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_permohonans_processed_by` FOREIGN KEY (`processed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: permohonan_files
CREATE TABLE `permohonan_files` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `permohonan_id` int(11) UNSIGNED NOT NULL,
  `jenis_file` enum('ktp','surat_kuasa','pendukung','generated_pdf') NOT NULL DEFAULT 'pendukung',
  `nama_file` varchar(255) NOT NULL,
  `path_file` varchar(255) NOT NULL,
  `ukuran_file` int(11) UNSIGNED NOT NULL,
  `mime_type` varchar(100) NOT NULL,
  `uploaded_by` int(11) UNSIGNED NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_permohonan_id` (`permohonan_id`),
  KEY `idx_jenis_file` (`jenis_file`),
  CONSTRAINT `fk_permohonan_files_permohonan_id` FOREIGN KEY (`permohonan_id`) REFERENCES `permohonans` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_permohonan_files_uploaded_by` FOREIGN KEY (`uploaded_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert sample data
INSERT INTO `users` (`username`, `email`, `password`, `role`, `is_active`, `email_verified_at`, `created_at`, `updated_at`) VALUES
('admin', 'admin@pn-watampone.go.id', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1, NOW(), NOW(), NOW()),
('petugas1', 'petugas1@pn-watampone.go.id', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'petugas', 1, NOW(), NOW(), NOW()),
('petugas2', 'petugas2@pn-watampone.go.id', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'petugas', 1, NOW(), NOW(), NOW()),
('pemohon_demo', 'pemohon@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'pemohon', 1, NOW(), NOW(), NOW());

-- Insert pemohon profile for demo
INSERT INTO `pemohon_profiles` (`user_id`, `nama_lengkap`, `nik`, `no_telepon`, `alamat`, `status_verified`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES
(4, 'Pemohon Demo', '1234567890123456', '081234567890', 'Jl. Contoh No. 123, Watampone', 'verified', 2, NOW(), NOW(), NOW());

-- Default password for all demo accounts: password
