<?php
// Setup Database Tables untuk Aplikasi Permohonan Salinan Putusan
// Author: System
// Date: 2025

echo "<h1>🚀 SETUP DATABASE TABLES</h1>";
echo "<hr>";

$config = [
    'host' => 'localhost',
    'database' => 'pnwy4699_permohonan',
    'username' => 'pnwy4699_dbuser',
    'password' => 'MyPass123456789!'
];

try {
    echo "<p>📡 Connecting to database...</p>";
    
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    echo "<p>✅ <strong>Database connection successful!</strong></p>";
    echo "<p>Database: {$config['database']}</p>";
    echo "<p>User: {$config['username']}</p>";
    echo "<hr>";
    
    // Create users table
    echo "<p>📝 Creating table: <strong>users</strong></p>";
    $sql_users = "
    CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nama_lengkap VARCHAR(255) NOT NULL,
        username VARCHAR(100) UNIQUE NOT NULL,
        email VARCHAR(255) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        role ENUM('admin', 'user') DEFAULT 'user',
        nomor_hp VARCHAR(20),
        alamat TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql_users);
    echo "<p>✅ Table 'users' created successfully!</p>";
    
    // Create permohonans table
    echo "<p>📝 Creating table: <strong>permohonans</strong></p>";
    $sql_permohonans = "
    CREATE TABLE IF NOT EXISTS permohonans (
        id INT AUTO_INCREMENT PRIMARY KEY,
        pemohon_id INT NOT NULL,
        kode_permohonan VARCHAR(20) UNIQUE NOT NULL,
        nomor_perkara VARCHAR(100) NOT NULL,
        tahun_perkara INT NOT NULL,
        para_pihak TEXT NOT NULL,
        jenis_perkara VARCHAR(50) NOT NULL,
        kebutuhan VARCHAR(100) NOT NULL,
        keperluan TEXT NOT NULL,
        status ENUM('pending', 'diproses', 'selesai', 'ditolak') DEFAULT 'pending',
        catatan TEXT,
        tanggal_selesai DATE NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (pemohon_id) REFERENCES users(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql_permohonans);
    echo "<p>✅ Table 'permohonans' created successfully!</p>";
    
    // Create permohonan_files table
    echo "<p>📝 Creating table: <strong>permohonan_files</strong></p>";
    $sql_files = "
    CREATE TABLE IF NOT EXISTS permohonan_files (
        id INT AUTO_INCREMENT PRIMARY KEY,
        permohonan_id INT NOT NULL,
        nama_file VARCHAR(255) NOT NULL,
        nama_asli VARCHAR(255) NOT NULL,
        file_path VARCHAR(500) NOT NULL,
        file_type VARCHAR(100) NOT NULL,
        file_size INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (permohonan_id) REFERENCES permohonans(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql_files);
    echo "<p>✅ Table 'permohonan_files' created successfully!</p>";
    
    // Create system_settings table
    echo "<p>📝 Creating table: <strong>system_settings</strong></p>";
    $sql_settings = "
    CREATE TABLE IF NOT EXISTS system_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT,
        description TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo->exec($sql_settings);
    echo "<p>✅ Table 'system_settings' created successfully!</p>";
    
    // Insert default settings
    echo "<p>📝 Inserting default settings...</p>";
    $default_settings = [
        ['kop_surat_name', 'PENGADILAN NEGERI WATAMPONE', 'Nama instansi untuk kop surat'],
        ['kop_surat_address', 'Jl. Veteran No. 1 Watampone, Bone', 'Alamat instansi'],
        ['kop_surat_phone', 'Telp. (0481) 21234', 'Nomor telepon instansi'],
        ['max_file_size', '2048', 'Maksimal ukuran file upload dalam KB'],
        ['allowed_file_types', 'pdf,jpg,jpeg,png', 'Tipe file yang diizinkan'],
        ['app_name', 'Sistem Permohonan Salinan Putusan', 'Nama aplikasi'],
        ['app_version', '1.0.0', 'Versi aplikasi']
    ];
    
    foreach ($default_settings as $setting) {
        $stmt = $pdo->prepare("INSERT IGNORE INTO system_settings (setting_key, setting_value, description) VALUES (?, ?, ?)");
        $stmt->execute($setting);
    }
    echo "<p>✅ Default settings inserted!</p>";
    
    // Check created tables
    echo "<hr>";
    echo "<h3>📊 SUMMARY - Tables Created:</h3>";
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tables)) {
        echo "<p>❌ No tables found!</p>";
    } else {
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li>✅ <strong>$table</strong></li>";
        }
        echo "</ul>";
    }
    
    echo "<hr>";
    echo "<h2>🎉 DATABASE SETUP COMPLETED SUCCESSFULLY!</h2>";
    echo "<h3>Next Steps:</h3>";
    echo "<ol>";
    echo "<li>Create admin user: <a href='create_admin.php'>create_admin.php</a></li>";
    echo "<li>Access main application: <a href='./'>Go to Application</a></li>";
    echo "<li>Delete this file for security</li>";
    echo "</ol>";
    
} catch (PDOException $e) {
    echo "<h2>❌ DATABASE SETUP FAILED!</h2>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<h3>🔧 Troubleshooting:</h3>";
    echo "<ul>";
    echo "<li>Check database connection settings</li>";
    echo "<li>Verify user has CREATE privileges</li>";
    echo "<li>Check database exists</li>";
    echo "</ul>";
}
?>
