<?php
$config = [
    'host' => 'localhost',
    'database' => 'pnwy4699_permohonan',
    'username' => 'pnwy4699_dbuser',
    'password' => 'MyPass123456789!'
];

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    // Create permohonans table
    $sql = "
    CREATE TABLE IF NOT EXISTS permohonans (
        id INT AUTO_INCREMENT PRIMARY KEY,
        pemohon_id INT NOT NULL,
        kode_permohonan VARCHAR(20) UNIQUE NOT NULL,
        nomor_perkara VARCHAR(100) NOT NULL,
        tahun_perkara INT NOT NULL,
        para_pihak TEXT NOT NULL,
        jenis_perkara VARCHAR(50) NOT NULL,
        kebutuhan VARCHAR(100) NOT NULL,
        keterangan TEXT,
        status ENUM('pending', 'processing', 'completed', 'rejected') DEFAULT 'pending',
        rejection_reason TEXT,
        processed_by INT,
        processed_at TIMESTAMP NULL,
        completed_at TIMESTAMP NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "Table 'permohonans' created successfully.\n";
    
    // Create permohonan_files table
    $sql = "
    CREATE TABLE IF NOT EXISTS permohonan_files (
        id INT AUTO_INCREMENT PRIMARY KEY,
        permohonan_id INT NOT NULL,
        file_name VARCHAR(255) NOT NULL,
        file_path VARCHAR(500) NOT NULL,
        file_type VARCHAR(100) NOT NULL,
        file_size INT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    $pdo->exec($sql);
    echo "Table 'permohonan_files' created successfully.\n";
    
    echo "Database tables created successfully!\n";
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
