<?php
$config = [
    'host' => 'localhost',
    'username' => 'root',
    'password' => '',
    'database' => 'permohonan_salinan_putusan'
];

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );

    echo "=== DATABASE CONNECTION SUCCESS ===\n";
    
    // Check if tables exist
    $tables = $pdo->query("SHOW TABLES")->fetchAll();
    echo "\nTables in database:\n";
    foreach ($tables as $table) {
        echo "- " . array_values($table)[0] . "\n";
    }
    
    // Check permohonans data
    echo "\n=== PERMOHONANS DATA ===\n";
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM permohonans");
    $result = $stmt->fetch();
    echo "Total permohonans: " . $result['total'] . "\n";
    
    if ($result['total'] > 0) {
        $stmt = $pdo->query("SELECT id, kode_permohonan, nomor_perkara, status, created_at FROM permohonans LIMIT 5");
        $permohonans = $stmt->fetchAll();
        
        echo "\nSample data:\n";
        foreach ($permohonans as $p) {
            echo "ID: {$p['id']}, Kode: {$p['kode_permohonan']}, Nomor: {$p['nomor_perkara']}, Status: {$p['status']}\n";
        }
    }
    
    // Check users data
    echo "\n=== USERS DATA ===\n";
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users");
    $result = $stmt->fetch();
    echo "Total users: " . $result['total'] . "\n";
    
    if ($result['total'] > 0) {
        $stmt = $pdo->query("SELECT id, username, email, role FROM users LIMIT 5");
        $users = $stmt->fetchAll();
        
        echo "\nSample users:\n";
        foreach ($users as $u) {
            echo "ID: {$u['id']}, Username: {$u['username']}, Email: {$u['email']}, Role: {$u['role']}\n";
        }
    }
    
} catch (PDOException $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
