<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? $title : 'Permohonan Salinan Putusan' ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <style>
        .navbar-brand img {
            height: 40px;
        }
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .btn-custom {
            border-radius: 25px;
            padding: 10px 30px;
            font-weight: 600;
        }
        .footer {
            background-color: #1e3a8a;
            color: white;
            padding: 20px 0;
        }
        .status-badge {
            font-size: 0.875rem;
            padding: 0.375rem 0.75rem;
            border-radius: 0.5rem;
        }
        .bg-pending { background-color: #fbbf24; color: #92400e; }
        .bg-diterima { background-color: #60a5fa; color: #1e40af; }
        .bg-diproses { background-color: #34d399; color: #065f46; }
        .bg-selesai { background-color: #10b981; color: #064e3b; }
        .bg-ditolak { background-color: #f87171; color: #991b1b; }
        .bg-verified { background-color: #10b981; color: #064e3b; }
        .bg-rejected { background-color: #f87171; color: #991b1b; }
    </style>
    <?= $this->renderSection('head') ?>
</head>
<body class="bg-light">
    
    <!-- Navigation -->
    <?php if (session()->get('isLoggedIn')): ?>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand" href="/">
                <i class="fas fa-gavel me-2"></i>
                PN Watampone
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <?php
                    $role = session()->get('role');
                    $currentPath = current_url(true)->getPath();
                    ?>
                    
                    <?php if ($role === 'admin'): ?>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/admin/dashboard') !== false ? 'active' : '' ?>" href="/admin/dashboard">
                                <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/admin/users') !== false ? 'active' : '' ?>" href="/admin/users">
                                <i class="fas fa-users me-1"></i> Kelola User
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/admin/permohonans') !== false ? 'active' : '' ?>" href="/admin/permohonans">
                                <i class="fas fa-file-alt me-1"></i> Semua Permohonan
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if ($role === 'petugas'): ?>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/petugas/dashboard') !== false ? 'active' : '' ?>" href="/petugas/dashboard">
                                <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/petugas/verifikasi') !== false ? 'active' : '' ?>" href="/petugas/verifikasi">
                                <i class="fas fa-user-check me-1"></i> Verifikasi Akun
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/petugas/permohonans') !== false ? 'active' : '' ?>" href="/petugas/permohonans">
                                <i class="fas fa-file-alt me-1"></i> Kelola Permohonan
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if ($role === 'pemohon'): ?>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/pemohon/dashboard') !== false ? 'active' : '' ?>" href="/pemohon/dashboard">
                                <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/pemohon/permohonan') !== false ? 'active' : '' ?>" href="/pemohon/permohonan">
                                <i class="fas fa-file-plus me-1"></i> Ajukan Permohonan
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?= strpos($currentPath, '/pemohon/riwayat') !== false ? 'active' : '' ?>" href="/pemohon/riwayat">
                                <i class="fas fa-history me-1"></i> Riwayat Permohonan
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?= session()->get('username') ?>
                            <span class="badge bg-light text-dark ms-1"><?= ucfirst(session()->get('role')) ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="/profile"><i class="fas fa-user-edit me-2"></i> Profil</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="/logout"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <?php endif; ?>

    <!-- Main Content -->
    <main class="<?= session()->get('isLoggedIn') ? 'py-4' : '' ?>">
        <!-- Flash Messages -->
        <?php if (session()->getFlashdata('success')): ?>
            <div class="container">
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= session()->getFlashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('error')): ?>
            <div class="container">
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= session()->getFlashdata('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        <?php endif; ?>

        <?php if (session()->getFlashdata('warning')): ?>
            <div class="container">
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?= session()->getFlashdata('warning') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        <?php endif; ?>

        <!-- Page Content -->
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <?php if (session()->get('isLoggedIn')): ?>
    <footer class="footer mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h6><i class="fas fa-gavel me-2"></i>Pengadilan Negeri Watampone</h6>
                    <p class="mb-0">Sistem Permohonan Salinan Putusan Online</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; <?= date('Y') ?> PN Watampone. All rights reserved.</p>
                    <small>Developed with ❤️ using CodeIgniter 4</small>
                </div>
            </div>
        </div>
    </footer>
    <?php endif; ?>

    <!-- Bootstrap 5 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);

        // Confirm delete actions
        function confirmDelete(message = 'Apakah Anda yakin ingin menghapus data ini?') {
            return confirm(message);
        }

        // Format file size
        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }

        // Status badge helper
        function getStatusBadge(status) {
            const badges = {
                'pending': '<span class="badge bg-pending">Pending</span>',
                'diterima': '<span class="badge bg-diterima">Diterima</span>',
                'diproses': '<span class="badge bg-diproses">Diproses</span>',
                'selesai': '<span class="badge bg-selesai">Selesai</span>',
                'ditolak': '<span class="badge bg-ditolak">Ditolak</span>',
                'verified': '<span class="badge bg-verified">Verified</span>',
                'rejected': '<span class="badge bg-rejected">Rejected</span>'
            };
            return badges[status] || status;
        }
    </script>
    
    <?= $this->renderSection('scripts') ?>
</body>
</html>
