<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class RoleFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // Check if user is logged in
        if (!session()->get('isLoggedIn')) {
            return redirect()->to('/login')->with('error', 'Silakan login terlebih dahulu');
        }

        $userRole = session()->get('role');
        
        // If no role specified in arguments, allow all authenticated users
        if (empty($arguments)) {
            return;
        }

        // Check if user role is in allowed roles
        $allowedRoles = is_array($arguments) ? $arguments : [$arguments];
        
        if (!in_array($userRole, $allowedRoles)) {
            return redirect()->back()->with('error', 'Anda tidak memiliki akses ke halaman ini');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do nothing
    }
}
