<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UsersSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'username'          => 'admin',
                'email'             => 'admin@pn-watampone.go.id',
                'password'          => password_hash('admin123', PASSWORD_DEFAULT),
                'role'              => 'admin',
                'is_active'         => true,
                'email_verified_at' => date('Y-m-d H:i:s'),
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ],
            [
                'username'          => 'petugas1',
                'email'             => 'petugas1@pn-watampone.go.id',
                'password'          => password_hash('petugas123', PASSWORD_DEFAULT),
                'role'              => 'petugas',
                'is_active'         => true,
                'email_verified_at' => date('Y-m-d H:i:s'),
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ],
            [
                'username'          => 'petugas2',
                'email'             => 'petugas2@pn-watampone.go.id',
                'password'          => password_hash('petugas123', PASSWORD_DEFAULT),
                'role'              => 'petugas',
                'is_active'         => true,
                'email_verified_at' => date('Y-m-d H:i:s'),
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ],
            [
                'username'          => 'pemohon_demo',
                'email'             => 'pemohon@example.com',
                'password'          => password_hash('pemohon123', PASSWORD_DEFAULT),
                'role'              => 'pemohon',
                'is_active'         => true,
                'email_verified_at' => date('Y-m-d H:i:s'),
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ],
        ];

        $this->db->table('users')->insertBatch($data);
        
        // Insert demo pemohon profile
        $pemohonProfile = [
            'user_id'         => 4, // pemohon_demo ID
            'nama_lengkap'    => 'Pemohon Demo',
            'nik'             => '1234567890123456',
            'no_telepon'      => '081234567890',
            'alamat'          => 'Jl. Contoh No. 123, Watampone',
            'status_verified' => 'verified',
            'verified_by'     => 2, // petugas1 ID
            'verified_at'     => date('Y-m-d H:i:s'),
            'created_at'      => date('Y-m-d H:i:s'),
            'updated_at'      => date('Y-m-d H:i:s'),
        ];
        
        $this->db->table('pemohon_profiles')->insert($pemohonProfile);
    }
}
