<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\UserModel;
use App\Models\PemohonProfileModel;
use App\Models\PermohonanModel;

class DashboardController extends BaseController
{
    protected $userModel;
    protected $pemohonProfileModel;
    protected $permohonanModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->pemohonProfileModel = new PemohonProfileModel();
        $this->permohonanModel = new PermohonanModel();
    }

    public function index()
    {
        // Get statistics
        $data = [
            'title' => 'Dashboard Admin - Permohonan Salinan Putusan',
            'stats' => [
                'users' => $this->getUserStatistics(),
                'pemohon' => $this->pemohonProfileModel->getStatistics(),
                'permohonan' => $this->permohonanModel->getStatistics(),
            ],
            'recent_permohonans' => $this->permohonanModel->getAllPermohonansWithUsers(5),
            'pending_verifications' => $this->pemohonProfileModel->getPendingProfiles(),
        ];

        return view('admin/dashboard', $data);
    }

    private function getUserStatistics()
    {
        $stats = [
            'total' => $this->userModel->countAllResults(),
            'admin' => $this->userModel->where('role', 'admin')->countAllResults(),
            'petugas' => $this->userModel->where('role', 'petugas')->countAllResults(),
            'pemohon' => $this->userModel->where('role', 'pemohon')->countAllResults(),
            'active' => $this->userModel->where('is_active', true)->countAllResults(),
            'inactive' => $this->userModel->where('is_active', false)->countAllResults(),
        ];

        return $stats;
    }
}
