<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Default route - redirect to auth
$routes->get('/', 'AuthController::index');

// Authentication routes
$routes->group('', function($routes) {
    $routes->get('login', 'AuthController::login');
    $routes->post('login', 'AuthController::attemptLogin');
    $routes->get('register', 'AuthController::register');
    $routes->post('register', 'AuthController::attemptRegister');
    $routes->get('logout', 'AuthController::logout');
});

// Admin routes
$routes->group('admin', ['filter' => 'role:admin'], function($routes) {
    $routes->get('dashboard', 'Admin\DashboardController::index');
    $routes->get('users', 'Admin\UserController::index');
    $routes->get('users/create', 'Admin\UserController::create');
    $routes->post('users', 'Admin\UserController::store');
    $routes->get('users/(:num)/edit', 'Admin\UserController::edit/$1');
    $routes->put('users/(:num)', 'Admin\UserController::update/$1');
    $routes->delete('users/(:num)', 'Admin\UserController::delete/$1');
    $routes->get('permohonans', 'Admin\PermohonanController::index');
    $routes->get('permohonans/(:num)', 'Admin\PermohonanController::detail/$1');
});

// Petugas routes
$routes->group('petugas', ['filter' => 'role:petugas'], function($routes) {
    $routes->get('dashboard', 'Petugas\DashboardController::index');
    $routes->get('verifikasi', 'Petugas\VerifikasiController::index');
    $routes->post('verifikasi/(:num)/approve', 'Petugas\VerifikasiController::approve/$1');
    $routes->post('verifikasi/(:num)/reject', 'Petugas\VerifikasiController::reject/$1');
    $routes->get('permohonans', 'Petugas\PermohonanController::index');
    $routes->get('permohonans/(:num)', 'Petugas\PermohonanController::detail/$1');
    $routes->post('permohonans/(:num)/update-status', 'Petugas\PermohonanController::updateStatus/$1');
});

// Pemohon routes
$routes->group('pemohon', ['filter' => 'role:pemohon'], function($routes) {
    $routes->get('dashboard', 'Pemohon\DashboardController::index');
    $routes->get('permohonan', 'Pemohon\PermohonanController::create');
    $routes->post('permohonan', 'Pemohon\PermohonanController::store');
    $routes->get('permohonan/(:num)', 'Pemohon\PermohonanController::detail/$1');
    $routes->get('riwayat', 'Pemohon\PermohonanController::index');
});

// File download routes (with authentication)
$routes->group('files', ['filter' => 'auth'], function($routes) {
    $routes->get('ktp/(:segment)', 'FileController::downloadKtp/$1');
    $routes->get('permohonan/(:segment)', 'FileController::downloadPermohonan/$1');
    $routes->get('pdf/(:num)', 'FileController::generatePdf/$1');
});

// API routes (optional for future mobile app)
$routes->group('api', function($routes) {
    $routes->post('login', 'Api\AuthController::login');
    $routes->get('permohonans', 'Api\PermohonanController::index', ['filter' => 'auth']);
});
