# Update Tampilan Sederhana - Permohonan Salinan Putusan

## Perubahan yang Dilakukan

### 1. Desain Homepage Disederhanakan
- **Hero Section**: Lebih clean dengan gradient solid blue (#2563eb, #1e40af)
- **Menghapus background image**: Hero section sekarang menggunakan gradient polos
- **Logo posisi**: Logo dipindah ke tengah hero section dengan ukuran 60px
- **Typography**: Menggunakan display-5 untuk heading yang lebih proportional
- **Button styling**: Border radius dikurangi (8px), padding disesuaikan

### 2. Navbar Simplified
- **Background**: Solid blue (#1e40af) menggantikan gradient
- **Logo size**: Dikurangi dari 40px ke 35px
- **Menu items**: Menghapus icon, hanya text
- **Typography**: Lebih clean dan minimal

### 3. Features Section Minimalis
- **Jumlah fitur**: Dikurangi dari 6 menjadi 3 fitur utama
- **Card design**: Tanpa border, shadow tipis, padding lebih kecil
- **Icons**: Ukuran 3x dengan warna primary consistent
- **Content**: Deskripsi lebih ringkas dan to-the-point

### 4. About Section Streamlined
- **Layout**: Single column center-aligned
- **Contact info**: Dipindah ke format icon + text horizontal
- **Background image**: Dihapus untuk tampilan lebih clean
- **Logo integration**: Logo ditampilkan di atas heading

### 5. Jenis Perkara Disederhanakan
**Sebelum (6 jenis):**
- Perdata Umum
- Pidana
- Perdata Agama  
- Tata Usaha Negara
- Niaga
- Hubungan Industrial

**Sesudah (2 jenis):**
- Perdata
- Pidana

### 6. Kebutuhan Salinan Disederhanakan
**Sebelum (3 jenis):**
- Salinan Putusan
- Grosse Akta
- Salinan Putusan & Grosse Akta

**Sesudah (1 jenis):**
- Salinan Putusan

### 7. Perbaikan Validasi Nomor Perkara
- **Regex Lama**: `/^\d+\/(Pdt|Pid)(\.\w+)*\/\d{4}\/[A-Z]+$/`
- **Regex Baru**: `/^\d+\/(Pdt|Pid)(\.\w+)*\/\d{4}\/\w+$/`
- **Tujuan**: Mengakomodasi format nomor perkara yang lebih beragam

### 8. CSS Improvements
```css
.hero-section {
    background: linear-gradient(135deg, #2563eb, #1e40af);
    padding: 80px 0; /* dikurangi dari 120px */
}

.feature-card {
    border-radius: 10px; /* dikurangi dari 15px */
    box-shadow: 0 4px 20px rgba(0,0,0,0.08); /* lebih tipis */
    padding: 1.5rem;
}

.btn-custom {
    border-radius: 8px; /* dikurangi dari 25px */
    padding: 12px 24px; /* disesuaikan */
    font-weight: 500; /* dikurangi dari 600 */
}
```

## File yang Dimodifikasi

### 1. public/home.php
- Hero section styling
- Features section content
- About section layout
- CSS variables dan styling

### 2. public/permohonan-baru.php
- Dropdown jenis perkara
- Opsi dikurangi menjadi 2 pilihan

### 3. Styling Global
- Color scheme lebih konsisten
- Typography hierarchy diperbaiki
- Spacing dan padding disesuaikan

## Hasil Akhir

### Sebelum:
- Tampilan kompleks dengan banyak fitur
- Background image yang berat
- 6 jenis perkara
- Gradient kompleks
- Banyak section dan statistik

### Sesudah:  
- Tampilan clean dan minimal
- Solid color background
- 2 jenis perkara saja
- Gradient sederhana
- Fokus pada fitur utama

## Benefits

1. **Loading Performance**: Lebih cepat tanpa background image
2. **User Experience**: Navigasi lebih sederhana dan fokus
3. **Maintenance**: Lebih mudah dikelola dan diupdate
4. **Mobile Responsive**: Layout sederhana lebih baik di mobile
5. **Professional Look**: Clean design terlihat lebih profesional

## Testing

- ✅ Homepage load dengan design baru
- ✅ Form permohonan dengan 2 jenis perkara
- ✅ Responsive di berbagai ukuran layar
- ✅ Logo dan gambar loading dengan baik
- ✅ Navigation dan interaksi berfungsi normal
