# Troubleshooting Gambar Tidak Muncul

## Masalah yang Dihadapi
Logo dan gambar tidak muncul di aplikasi web Permohonan Salinan Putusan PN Watampone.

## Penyebab Kemungkinan
1. **Path gambar yang salah** - Path relatif atau absolut tidak sesuai dengan struktur folder
2. **Konfigurasi .htaccess** - Rewrite rules yang memblokir akses ke file gambar
3. **Cache browser** - Browser menyimpan versi lama yang error
4. **Permission file/folder** - Server tidak dapat mengakses folder gambar

## Solusi yang Telah Dicoba

### 1. Perbaikan Path Gambar
- **Path Relatif**: `../gambar/Logo_pnwtp.png` (dari folder public/)
- **Path Absolut**: `/permohonan-salinan-putusan/gambar/Logo_pnwtp.png`
- **Dynamic Path**: PHP function untuk generate URL otomatis

### 2. Perbaikan .htaccess
```apache
# Allow access to static files (images, css, js)
RewriteCond %{REQUEST_URI} \.(png|jpg|jpeg|gif|css|js|ico)$ [NC]
RewriteRule ^(.*)$ - [L]

# Redirect all other requests to public directory (except static files)
RewriteCond %{REQUEST_URI} !^/public/
RewriteCond %{REQUEST_URI} !\.(png|jpg|jpeg|gif|css|js|ico)$ [NC]
RewriteRule ^(.*)$ public/setup.php [L,QSA]
```

### 3. Cache Busting
Menambahkan timestamp untuk memaksa reload:
```html
<img src="../gambar/Logo_pnwtp.png?v=<?php echo time(); ?>">
```

## File yang Diperbaiki
- `public/home.php` - Logo navbar, hero section, about section
- `public/dashboard.php` - Logo navbar
- `public/verifikasi.php` - Logo navbar
- `public/permohonan-baru.php` - Logo navbar
- `public/permohonan-saya.php` - Logo navbar
- `public/detail-permohonan.php` - Logo navbar, kop surat
- `public/galeri.php` - Logo navbar, galeri images
- `.htaccess` - Rewrite rules untuk static files

## Status File Gambar
- ✅ `gambar/Logo_pnwtp.png` - 104,741 bytes
- ✅ `gambar/gedung-pn-wtp.png` - 658,594 bytes  
- ✅ `gambar/kop_surat.png` - 119,280 bytes

## Test yang Dilakukan
1. **Direct Access**: `http://localhost/permohonan-salinan-putusan/gambar/Logo_pnwtp.png` ✅
2. **Path Testing**: Berbagai variasi path di file HTML/PHP
3. **Debug Script**: File PHP untuk cek path dan file existence

## Langkah Selanjutnya
1. **Hard Refresh Browser**: Ctrl+F5 atau Ctrl+Shift+R
2. **Clear Browser Cache**: Settings → Clear browsing data
3. **Check Console Errors**: F12 → Console tab untuk error messages
4. **Verify .htaccess**: Pastikan rules tidak conflict
5. **Check Permissions**: Folder gambar harus readable (755)

## Konfigurasi Server
- **Web Server**: Apache (XAMPP)
- **Document Root**: `c:\xampp\htdocs\permohonan-salinan-putusan`
- **Application Structure**:
  ```
  permohonan-salinan-putusan/
  ├── gambar/           # Image files
  ├── public/           # PHP application files
  ├── index.php         # Front controller
  └── .htaccess         # Apache configuration
  ```
