# PANDUAN HOSTING DI RUMAHWEB.COM

## Persyaratan Hosting
- ✅ PHP 7.4+ (Aplikasi menggunakan PHP 8.0+)
- ✅ MySQL Database 
- ✅ Apache dengan mod_rewrite (.htaccess)
- ✅ Minimum 100MB storage
- ✅ SSL Certificate (opsional tapi direkomendasikan)

## Langkah-langkah Upload

### 1. Persiapan File
```bash
# Compress semua file aplikasi (kecuali vendor/ jika ada)
zip -r permohonan-salinan-putusan.zip . -x "*.git*" "vendor/*"
```

### 2. Setup Database di cPanel
1. Login ke **cPanel RumahWeb**
2. Cari menu **"MySQL Databases"**
3. **Buat Database Baru:**
   - Database Name: `permohonan`
   - Hasil: `username_permohonan` (prefix otomatis)
4. **Buat User Database:**
   - Username: `dbuser`
   - Password: `[password_kuat]`
   - Hasil: `username_dbuser`
5. **Assign User ke Database:**
   - Pilih user dan database
   - Berikan privilege **ALL PRIVILEGES**

### 3. Upload File via cPanel
1. Buka **File Manager** di cPanel
2. Masuk ke folder **`public_html`**
3. **Upload** file `permohonan-salinan-putusan.zip`
4. **Extract** file zip
5. **Hapus** file zip setelah extract

### 4. Konfigurasi Database
1. Edit file `config_hosting.php` dengan informasi database:
```php
$config = [
    'host' => 'localhost',
    'database' => 'username_permohonan', // Sesuai dengan database yang dibuat
    'username' => 'username_dbuser',     // Sesuai dengan user yang dibuat
    'password' => 'password_anda'        // Password yang Anda buat
];
```

2. **Update semua file PHP** yang menggunakan konfigurasi database:
   - `create_tables.php`
   - `public/print-permohonan.php`
   - File lain yang menggunakan koneksi database

### 5. Setup Database Tables
1. Buka browser dan akses: `https://domain-anda.com/create_tables.php`
2. Script akan membuat tabel otomatis
3. **Hapus file** `create_tables.php` setelah selesai (keamanan)

### 6. Set File Permissions
```bash
# Via File Manager cPanel atau Terminal (jika tersedia)
chmod 755 public/
chmod 755 assets/
chmod 777 uploads/  # Folder untuk upload file
chmod 644 *.php
chmod 644 .htaccess
```

### 7. Upload Asset Gambar
Upload file gambar ke folder yang benar:
- `assets/images/Logo_pnwtp.png`
- `assets/images/gedung-pn-wtp.png`
- `assets/images/kop_surat.png`

### 8. Testing
1. Akses website: `https://domain-anda.com`
2. Test registrasi user baru
3. Test login
4. Test buat permohonan
5. Test fitur print

## Paket Hosting yang Direkomendasikan

### **Paket Minimal (Personal/Starter)**
- Disk Space: 1GB (cukup untuk aplikasi ini)
- Bandwidth: 10GB/bulan
- Database: 1 MySQL database
- PHP: 7.4+

### **Paket Direkomendasikan (Business)**
- Disk Space: 5GB+
- Bandwidth: Unlimited
- Database: Multiple MySQL
- Backup otomatis
- SSL Certificate gratis

## Keamanan Tambahan

### 1. Proteksi File Sensitif
Tambahkan ke `.htaccess`:
```apache
# Proteksi file konfigurasi
<Files "config_hosting.php">
    Order Allow,Deny
    Deny from all
</Files>

# Proteksi file setup
<Files "create_tables.php">
    Order Allow,Deny
    Deny from all
</Files>
```

### 2. Database Security
- Gunakan password yang kuat untuk database user
- Jangan gunakan username 'root' di hosting
- Backup database secara rutin

### 3. SSL Certificate
- Aktifkan SSL gratis dari cPanel
- Update semua URL menjadi HTTPS
- Set redirect HTTP ke HTTPS

## Troubleshooting Umum

### Error 500 Internal Server Error
- Cek file `.htaccess` untuk syntax error
- Cek permission file (644 untuk .php, 755 untuk folder)
- Cek PHP error log di cPanel

### Database Connection Error
- Pastikan konfigurasi database benar
- Cek apakah user sudah di-assign ke database
- Pastikan database sudah dibuat

### File Upload Error
- Cek permission folder `uploads/` (777)
- Cek PHP upload limits di cPanel
- Pastikan folder uploads/ ada

## Contact Support
Jika mengalami masalah, hubungi:
- **RumahWeb Support**: https://www.rumahweb.com/support
- **Live Chat**: Tersedia 24/7
- **Ticket System**: Melalui client area

---
*Panduan ini berlaku untuk hosting di RumahWeb.com menggunakan cPanel*
